/**
 * Header Plugin
 * ปลั๊กอินสำหรับส่วนหัวของเว็บไซต์
 */
(function(global) {
  'use strict';

  /**
   * คลาส HeaderPlugin
   * ปลั๊กอินสำหรับส่วนหัวของเว็บไซต์
   */
  class HeaderPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'header';
      this.title = 'ส่วนหัว';
      this.icon = 'header';
      this.description = 'ส่วนหัวของเว็บไซต์';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('HeaderPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <header class="editor-component header" data-component="header">
                    <div class="container">
                        <div class="header-logo">
                            <h1 data-editable="true">โลโก้เว็บไซต์</h1>
                        </div>
                        <nav class="header-nav">
                            <ul>
                                <li><a href="#" data-editable="true">หน้าแรก</a></li>
                                <li><a href="#" data-editable="true">เกี่ยวกับ</a></li>
                                <li><a href="#" data-editable="true">บริการ</a></li>
                                <li><a href="#" data-editable="true">ผลงาน</a></li>
                                <li><a href="#" data-editable="true">ติดต่อ</a></li>
                            </ul>
                        </nav>
                        <div class="header-actions">
                            <button class="btn btn-outline" data-editable="true">เข้าสู่ระบบ</button>
                            <button class="btn btn-primary" data-editable="true">สมัครสมาชิก</button>
                        </div>
                    </div>
                </header>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .header {
                    background-color: #ffffff;
                    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                    padding: 15px 0;
                    position: sticky;
                    top: 0;
                    z-index: 100;
                }

                .header .container {
                    display: flex;
                    align-items: center;
                    justify-content: space-between;
                    max-width: 1200px;
                    margin: 0 auto;
                    padding: 0 20px;
                }

                .header-logo h1 {
                    margin: 0;
                    font-size: 24px;
                    color: #333;
                }

                .header-nav ul {
                    display: flex;
                    list-style: none;
                    margin: 0;
                    padding: 0;
                }

                .header-nav li {
                    margin: 0 15px;
                }

                .header-nav a {
                    text-decoration: none;
                    color: #333;
                    font-weight: 500;
                    transition: color 0.2s;
                }

                .header-nav a:hover {
                    color: #2196F3;
                }

                .header-actions {
                    display: flex;
                    gap: 10px;
                }

                .btn {
                    padding: 8px 16px;
                    border-radius: 4px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    border: none;
                }

                .btn-outline {
                    background-color: transparent;
                    border: 1px solid #2196F3;
                    color: #2196F3;
                }

                .btn-outline:hover {
                    background-color: #2196F3;
                    color: white;
                }

                .btn-primary {
                    background-color: #2196F3;
                    color: white;
                }

                .btn-primary:hover {
                    background-color: #1976D2;
                }

                @media (max-width: 768px) {
                    .header .container {
                        flex-direction: column;
                        gap: 15px;
                    }

                    .header-nav ul {
                        flex-wrap: wrap;
                        justify-content: center;
                    }

                    .header-nav li {
                        margin: 5px 10px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        logo: {
          type: 'text',
          label: 'ข้อความโลโก้',
          default: 'โลโก้เว็บไซต์'
        },
        backgroundColor: {
          type: 'color',
          label: 'สีพื้นหลัง',
          default: '#ffffff'
        },
        sticky: {
          type: 'checkbox',
          label: 'ติดด้านบน',
          default: true
        },
        showLoginButton: {
          type: 'checkbox',
          label: 'แสดงปุ่มเข้าสู่ระบบ',
          default: true
        },
        showSignupButton: {
          type: 'checkbox',
          label: 'แสดงปุ่มสมัครสมาชิก',
          default: true
        }
      };
    }
  }

  // เปิดเผยคลาส HeaderPlugin ทั่วโลก
  global.HeaderPlugin = HeaderPlugin;

})(typeof window !== 'undefined' ? window : this);