/**
 * Grid Plugin - ปลั๊กอินสำหรับเลย์เอาต์กริด
 */
(function(global) {
  'use strict';

  /**
   * คลาส GridPlugin
   * ปลั๊กอินสำหรับเลย์เอาต์กริด
   */
  class GridPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'grid';
      this.title = 'กริด';
      this.icon = 'grid_on';
      this.description = 'เลย์เอาต์กริด';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('GridPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <div class="editor-component grid" data-component="grid">
                    <div class="grid-container">
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 1</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 1 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 2</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 2 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 3</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 3 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 4</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 4 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 5</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 5 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                        <div class="grid-item">
                            <h3 data-editable="true">รายการ 6</h3>
                            <p data-editable="true">นี่คือเนื้อหาของรายการที่ 6 สามารถแก้ไขได้ตามต้องการ</p>
                        </div>
                    </div>
                </div>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .grid {
                    padding: 40px 0;
                }

                .grid .container {
                    max-width: 1200px;
                    margin: 0 auto;
                    padding: 0 20px;
                }

                .grid-container {
                    display: grid;
                    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
                    gap: 30px;
                }

                .grid-item {
                    background-color: white;
                    border-radius: 8px;
                    padding: 30px;
                    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
                    transition: transform 0.3s, box-shadow 0.3s;
                }

                .grid-item:hover {
                    transform: translateY(-5px);
                    box-shadow: 0 8px 16px rgba(0,0,0,0.15);
                }

                .grid-item h3 {
                    margin: 0 0 15px 0;
                    font-size: 22px;
                    color: #333;
                }

                .grid-item p {
                    margin: 0;
                    color: #666;
                    line-height: 1.6;
                }

                @media (max-width: 768px) {
                    .grid-container {
                        grid-template-columns: 1fr;
                        gap: 20px;
                    }

                    .grid-item {
                        padding: 20px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        columns: {
          type: 'select',
          label: 'จำนวนคอลัมน์',
          options: [
            {value: '1', text: '1 คอลัมน์'},
            {value: '2', text: '2 คอลัมน์'},
            {value: '3', text: '3 คอลัมน์'},
            {value: '4', text: '4 คอลัมน์'},
            {value: 'auto', text: 'อัตโนมัติ'}
          ],
          default: 'auto'
        },
        gap: {
          type: 'number',
          label: 'ระยะห่าง (px)',
          min: 0,
          max: 50,
          default: 30
        },
        backgroundColor: {
          type: 'color',
          label: 'สีพื้นหลัง',
          default: '#ffffff'
        },
        titleColor: {
          type: 'color',
          label: 'สีหัวข้อ',
          default: '#333333'
        },
        textColor: {
          type: 'color',
          label: 'สีข้อความ',
          default: '#666666'
        },
        hoverEffect: {
          type: 'checkbox',
          label: 'เอฟเฟกต์เมื่อชี้',
          default: true
        },
        itemsCount: {
          type: 'number',
          label: 'จำนวนรายการ',
          min: 1,
          max: 12,
          default: 6
        }
      };
    }
  }

  // เปิดเผยคลาส GridPlugin ทั่วโลก
  global.GridPlugin = GridPlugin;

})(typeof window !== 'undefined' ? window : this);