<?php
/**
 * config.php - ไฟล์กำหนดค่าการเชื่อมต่อฐานข้อมูล
 */

// กำหนดค่าการเชื่อมต่อกับฐานข้อมูล MySQL
define('DB_SERVER', 'localhost'); // เซิร์ฟเวอร์ฐานข้อมูล
define('DB_USERNAME', 'root'); // ชื่อผู้ใช้ฐานข้อมูล (เปลี่ยนตามที่คุณกำหนด)
define('DB_PASSWORD', ''); // รหัสผ่านฐานข้อมูล (เปลี่ยนตามที่คุณกำหนด)
define('DB_NAME', 'timeline_db'); // ชื่อฐานข้อมูล

// สร้างการเชื่อมต่อกับฐานข้อมูล
$conn = mysqli_connect(DB_SERVER, DB_USERNAME, DB_PASSWORD);

// ตรวจสอบการเชื่อมต่อ
if (!$conn) {
    die("การเชื่อมต่อล้มเหลว: ".mysqli_connect_error());
}

// สร้างฐานข้อมูลถ้ายังไม่มี
$sql = "CREATE DATABASE IF NOT EXISTS ".DB_NAME;
if (mysqli_query($conn, $sql)) {
    // เลือกฐานข้อมูล
    mysqli_select_db($conn, DB_NAME);
} else {
    die("ไม่สามารถสร้างฐานข้อมูล: ".mysqli_error($conn));
}

// สร้างตาราง tree_nodes ถ้ายังไม่มี
$sql = "CREATE TABLE IF NOT EXISTS tree_nodes (
    id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    level INT(11) NOT NULL,
    parent_id INT(11) NULL,
    node_order INT(11) NOT NULL DEFAULT 0,
    external_id VARCHAR(100) NULL,
    data TEXT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX (parent_id),
    INDEX (level),
    INDEX (external_id)
)";

if (!mysqli_query($conn, $sql)) {
    die("ไม่สามารถสร้างตาราง: ".mysqli_error($conn));
}

/**
 * ฟังก์ชันสำหรับปิดการเชื่อมต่อกับฐานข้อมูล
 */
function closeDbConnection()
{
    global $conn;
    mysqli_close($conn);
}

/**
 * ฟังก์ชันสำหรับตรวจสอบการเชื่อมต่อ
 */
function checkConnection()
{
    global $conn;
    return $conn ? true : false;
}
