# Tree Categories Manager

ระบบจัดการหมวดหมู่แบบต้นไม้หลายระดับชั้นด้วย JavaScript แบบ Pure ไม่ต้องใช้ไลบรารีเพิ่มเติม รองรับการลากวาง (Drag & Drop) เพื่อจัดการโครงสร้างได้อย่างง่ายดาย

## คุณสมบัติ

- **โครงสร้างแบบยืดหยุ่น:** สามารถกำหนดจำนวนระดับชั้นและชื่อของแต่ละระดับได้ตามต้องการ
- **ปรับแต่งง่าย:** เลือกโหมดระดับชั้นได้ทั้งแบบจำกัดจำนวนหรือไม่จำกัด
- **Drag & Drop:** รองรับการลากวางเพื่อจัดการโครงสร้างได้อย่างสะดวก
  - วางก่อนรายการ (Before)
  - วางหลังรายการ (After)
  - วางเป็นรายการย่อย (Inside)
- **UI ที่ใช้งานง่าย:**
  - ยุบ/ขยายโครงสร้างได้ทั้งแบบรายการเดียวหรือทั้งหมด
  - แสดงผลด้วยสีและไอคอนที่แตกต่างกันตามระดับชั้น
  - รองรับการแก้ไขชื่อรายการโดยตรง
- **จัดการข้อมูล:** สามารถบันทึกและโหลดโครงสร้างในรูปแบบ JSON

## การใช้งาน

### การตั้งค่าพื้นฐาน

1. **โหมดระดับชั้น:** เลือกระหว่างแบบจำกัดหรือไม่จำกัดระดับชั้น
2. **จำนวนระดับชั้น:** กำหนดจำนวนระดับชั้นที่ต้องการ (เฉพาะโหมดจำกัด)
3. **ชื่อระดับชั้น:** กำหนดชื่อของแต่ละระดับชั้น เช่น Stage, Area, Zone
4. **สร้างโครงสร้างเริ่มต้น:** กดปุ่ม "อัพเดตการตั้งค่า" เพื่อนำไปใช้

### การจัดการโครงสร้าง

- **เพิ่มรายการหลัก:** คลิกปุ่ม "เพิ่มรายการระดับบนสุด"
- **เพิ่มรายการย่อย:** คลิกปุ่ม "+" ที่แต่ละรายการ
- **ลบรายการ:** คลิกปุ่ม "×" ที่แต่ละรายการ
- **แก้ไขชื่อ:** คลิกที่ชื่อรายการแล้วแก้ไขได้ทันที

### การใช้งาน Drag & Drop

1. **ลากรายการ:** คลิกค้างที่รายการที่ต้องการย้าย
2. **วางในตำแหน่งที่ต้องการ:**
   - วางด้านบนของรายการอื่น (แสดงเส้นด้านบน) = วางก่อนรายการนั้น
   - วางตรงกลางของรายการอื่น (ไฮไลท์ทั้งรายการ) = วางเป็นรายการย่อย
   - วางด้านล่างของรายการอื่น (แสดงเส้นด้านล่าง) = วางหลังรายการนั้น

### การนำข้อมูลไปใช้

- **ดูโครงสร้าง JSON:** โครงสร้างทั้งหมดจะแสดงในส่วน "ผลลัพธ์ (JSON)"
- **คัดลอก JSON:** คลิกปุ่ม "คัดลอก JSON" เพื่อคัดลอกไปใช้งานต่อ
- **บันทึกเป็นไฟล์:** คลิกปุ่ม "บันทึก JSON" เพื่อดาวน์โหลดเป็นไฟล์
- **โหลดจากไฟล์:** คลิกปุ่ม "โหลดจากไฟล์" เพื่อนำเข้าข้อมูลจากไฟล์ JSON

## การติดตั้ง

1. คัดลอกโค้ดทั้งหมดไปไว้ในโปรเจคของคุณ
2. เรียกใช้ไฟล์ HTML หลักผ่านเว็บเซิร์ฟเวอร์

```html
<!-- ตัวอย่างการใช้งานพื้นฐาน -->
<div id="tree"></div>
<div id="json-output"></div>

<script>
  const treeManager = new TreeManager({
    containerId: 'tree',
    limitedDepth: true,
    maxDepth: 3,
    levelNames: {
      1: 'Stage',
      2: 'Area',
      3: 'Zone'
    },
    outputId: 'json-output'
  });

  // สร้างโครงสร้างเริ่มต้น
  treeManager.generateInitialStructure();
</script>
```

## การปรับแต่ง

ระบบรองรับการปรับแต่งในหลายด้าน:

- **สี**: แก้ไขตัวแปร CSS ในไฟล์ styles.css
- **ไอคอน**: สามารถเปลี่ยนไอคอนในฟังก์ชัน `_getIconForLevel` ในไฟล์ tree.js
- **รูปแบบ UI**: ปรับแต่ง CSS ได้ตามต้องการ

## การใช้งานขั้นสูง

### เหตุการณ์ (Event) สำคัญ

```javascript
// callback เมื่อมีการเปลี่ยนแปลงข้อมูล
treeManager.updateConfig({
  onChange: function(data) {
    console.log('ข้อมูลถูกเปลี่ยนแปลง:', data);
    // ดำเนินการอื่นๆ เช่น บันทึกลงฐานข้อมูล
  }
});
```

### การจัดเก็บข้อมูลลงฐานข้อมูล

สามารถนำข้อมูล JSON ที่ได้ไปจัดเก็บลงฐานข้อมูลผ่าน AJAX:

```javascript
// ตัวอย่างการส่งข้อมูลไปยัง API
document.getElementById('save-to-db').addEventListener('click', function() {
  const data = treeManager.getTreeData();

  fetch('/api/save-categories', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(data),
  })
  .then(response => response.json())
  .then(result => console.log('บันทึกสำเร็จ:', result))
  .catch(error => console.error('เกิดข้อผิดพลาด:', error));
});
```

## ใบอนุญาต

เผยแพร่ภายใต้ใบอนุญาต MIT

## ผู้พัฒนา

พัฒนาโดย [Goragod Wiriya](https://github.com/goragodwiriya)