# ระบบลงเวลาทำงาน (Time Attendance System)

ระบบลงเวลาทำงานผ่านเว็บเบราว์เซอร์ รองรับการจับภาพใบหน้าผู้ใช้งานและบันทึกตำแหน่งขณะลงเวลา พร้อมแสดงประวัติการลงเวลาแบบแยกแท็บ ใช้งานง่าย สะดวก และทันสมัย

## คุณสมบัติ
- ลงเวลา "เข้างาน" และ "ออกงาน" ด้วยการตรวจจับใบหน้าจริงผ่านกล้องเว็บแคม (ใช้ face-api.js)
- บันทึกภาพใบหน้าและตำแหน่ง (Geolocation) ขณะลงเวลา
- แสดงวัน เวลา สถานะ และผลการตรวจสอบใบหน้าพร้อมความแม่นยำ
- ประวัติการลงเวลาแยกแท็บ (ทั้งหมด/เข้างาน/ออกงาน)
- อินเทอร์เฟซสวยงาม รองรับมือถือและเดสก์ท็อป
- ข้อมูลจัดเก็บใน IndexedDB (ภายในเบราว์เซอร์)
- รองรับโหมดออฟไลน์ (ใช้ model ภายในเครื่อง)
- Fallback เป็นโหมดจำลองหากไม่สามารถโหลด face detection ได้

## วิธีใช้งาน
1. เปิดไฟล์ `index.html` ด้วยเว็บเบราว์เซอร์ที่รองรับ (Chrome, Edge, ฯลฯ)
2. กด "เปิดกล้อง" เพื่ออนุญาตการใช้งานกล้อง
3. เมื่อระบบตรวจพบใบหน้า สามารถกด "เข้างาน" หรือ "ออกงาน" ได้
4. ดูประวัติการลงเวลาได้ที่แท็บ "ประวัติ"

## โครงสร้างไฟล์
- `index.html` — หน้าเว็บหลัก
- `style.css` — ไฟล์สไตล์ (CSS)
- `main.js` — สคริปต์หลัก (JavaScript) พร้อม face detection จริง

## เทคโนโลยีที่ใช้
- **face-api.js** — TensorFlow.js-based face detection library (โหลดจาก GitHub/JSDelivr CDN)
- **SSD MobileNet v1** — AI model สำหรับตรวจจับใบหน้า
- **Multi-CDN Support** — รองรับหลาย CDN สำหรับความเสถียร
- **IndexedDB** — ฐานข้อมูลภายในเบราว์เซอร์
- **Geolocation API** — สำหรับระบุตำแหน่ง
- **MediaDevices API** — สำหรับเข้าถึงกล้อง
- **Network Status API** — ตรวจสอบสถานะการเชื่อมต่อ
> สร้างระบบลงเวลาทำงานผ่านเว็บเบราว์เซอร์ที่มีฟีเจอร์ดังนี้:
> - ลงเวลาเข้างาน/ออกงานด้วยการจับภาพใบหน้าผ่านกล้อง
> - บันทึกภาพใบหน้าและตำแหน่งขณะลงเวลา
> - แสดงประวัติการลงเวลาแบบแยกแท็บ (ทั้งหมด/เข้างาน/ออกงาน)
> - อินเทอร์เฟซสวยงาม ทันสมัย รองรับมือถือ
> - ข้อมูลจัดเก็บใน IndexedDB ภายในเบราว์เซอร์ ไม่ต้องใช้เซิร์ฟเวอร์

---

> ⚠️ **หมายเหตุสำคัญ:**
> ระบบนี้เป็นเพียงตัวอย่างการใช้งาน ข้อมูลจะถูกจัดเก็บเฉพาะในเบราว์เซอร์ของผู้ใช้ (IndexedDB) เท่านั้น ไม่ได้มีการจัดเก็บลงฐานข้อมูลส่วนกลางหรือเซิร์ฟเวอร์ หากต้องการใช้งานจริงในองค์กร ควรนำไปพัฒนาต่อเพื่อเชื่อมต่อและจัดเก็บข้อมูลในฐานข้อมูลที่เหมาะสมให้สมบูรณ์

**ผู้แต่ง:** Goragod Wiriya
