# Tic Tac Toe กับ AI ที่ไม่มีวันแพ้

Tic Tac Toe เป็นเกมคลาสสิกที่ผู้เล่นสองฝ่าย (X และ O) ผลัดกันวางสัญลักษณ์บนตาราง 3x3 โดยมีเป้าหมายเพื่อเรียงสัญลักษณ์ให้ครบ 3 ช่องในแนวนอน แนวตั้ง หรือแนวทแยง โปรเจ็กต์นี้พัฒนาขึ้นโดยใช้ **Vanilla JavaScript** และออกแบบให้มีโครงสร้างแบบโมดูล (Modules) เพื่อความยืดหยุ่นและขยายได้ง่าย โดยมีจุดเด่นคือการเพิ่ม **AI ที่ไม่มีวันแพ้** ซึ่งใช้ Minimax Algorithm เพื่อคำนวณการเคลื่อนไหวที่ดีที่สุด

## คุณสมบัติหลัก
- **ผู้เล่น vs AI**: ผู้เล่นเป็น "X" และ AI เป็น "O" โดย AI จะเล่นทันทีหลังจากผู้เล่นวางสัญลักษณ์
- **AI ที่ไม่มีวันแพ้**: AI ใช้ Minimax Algorithm เพื่อรับประกันว่าจะชนะหรืออย่างน้อยเสมอในทุกเกม
- **โครงสร้างแบบโมดูล**: แยกโค้ดเป็นส่วน ๆ (Game และ UI) เพื่อให้อ่านง่ายและขยายได้
- **ความปลอดภัย**: ป้องกัน XSS โดยใช้ `textContent` แทน `innerHTML`
- **ประสิทธิภาพ**: การจัดการ DOM ที่มีประสิทธิภาพและลดการคำนวณที่ไม่จำเป็น
- **Responsive Design**: ตารางและ UI ปรับขนาดได้ตามหน้าจอ
- **ไม่พึ่งพาไลบรารี**: ใช้ Vanilla JavaScript ล้วน ๆ รองรับการใช้งานบน Apache และ Nginx

## วัตถุประสงค์
โปรเจ็กต์นี้ถูกออกแบบมาเพื่อ:
- แสดงตัวอย่างการใช้ JavaScript ที่มีโครงสร้างแบบโมดูล
- นำเสนอการใช้งาน Minimax Algorithm ในเกมแบบ Turn-based
- สร้างโค้ดที่เข้าใจง่าย ขยายได้ และเหมาะกับการใช้งานจริง
- ให้ AI สามารถนำไปปรับใช้ในโปรเจ็กต์อื่น ๆ ได้

## วิธีการติดตั้ง
1. ดาวน์โหลดไฟล์ `index.html` จากโปรเจ็กต์นี้
2. วางไฟล์ในโฟลเดอร์ที่เซิร์ฟเวอร์ (เช่น Apache หรือ Nginx) สามารถเข้าถึงได้ หรือเปิดโดยตรงในเบราว์เซอร์
3. ไม่ต้องติดตั้งอะไรเพิ่มเติม เนื่องจากใช้ Vanilla JavaScript และไม่มี Dependency

## วิธีใช้งาน
1. เปิดไฟล์ `index.html` ในเบราว์เซอร์ (เช่น Chrome, Firefox)
2. คลิกที่ช่องในตาราง 3x3 เพื่อวางสัญลักษณ์ "X"
3. AI จะวาง "O" อัตโนมัติหลังจากคุณภายใน 0.5 วินาที
4. เล่นต่อไปจนกว่าจะมีผู้ชนะหรือเสมอ:
   - หากเรียงครบ 3 ช่องก่อน คุณ (X) จะชนะ
   - หาก AI (O) เรียงครบ 3 ช่องก่อน AI จะชนะ
   - หากเต็มตารางโดยไม่มีผู้ชนะ เกมจะเสมอ
5. กดปุ่ม "Reset Game" เพื่อเริ่มเกมใหม่

## รายละเอียดการออกแบบ
### โครงสร้างโค้ด
- **Game Module**: จัดการตรรกะของเกม เช่น การตรวจสอบผู้ชนะ การเคลื่อนไหวของผู้เล่นและ AI และ Minimax Algorithm
- **UI Module**: จัดการการแสดงผลและการโต้ตอบกับผู้ใช้ เช่น การอัปเดตตารางและข้อความสถานะ
- โมดูลทั้งสองแยกจากกันตามหลักการ **SOLID** (Single Responsibility) ทำให้สามารถปรับปรุงส่วนใดส่วนหนึ่งได้โดยไม่กระทบส่วนอื่น

### Minimax Algorithm
- AI ใช้ Minimax เพื่อคำนวณการเคลื่อนไหวที่ดีที่สุด:
  - คะแนน +10 ถ้า AI ชนะ
  - คะแนน -10 ถ้าผู้เล่นชนะ
  - คะแนน 0 ถ้าเสมอ
- อัลกอริทึมนี้รับประกันว่า AI จะไม่แพ้ โดยจะเลือกตำแหน่งที่ทำให้ชนะได้ทันที หรือบังคับให้เสมอหากไม่มีทางชนะ

### ความปลอดภัยและประสิทธิภาพ
- ใช้ `textContent` เพื่อป้องกัน XSS
- Minimax คำนวณเฉพาะช่องว่างที่มีอยู่ ลดการใช้ทรัพยากร
- การอัปเดต DOM ทำเฉพาะเมื่อจำเป็น

### UI/UX
- ตาราง 3x3 มี Hover Effect เพื่อความชัดเจน
- ข้อความสถานะเปลี่ยนตามเทิร์นของผู้เล่นและ AI
- ดีเลย์ 0.5 วินาทีของ AI ทำให้เกมดูเป็นธรรมชาติ

## การขยายในอนาคต
- เพิ่มระดับความยาก (เช่น ทำให้ AI เล่นแบบสุ่มบางครั้ง)
- ปรับขนาดตารางเป็น 4x4 หรือใหญ่กว่า
- เพิ่มระบบคะแนนหรือการบันทึกสถิติ
- ปรับแต่ง UI เช่น เปลี่ยนสีหรือเพิ่มอนิเมชัน

## ข้อจำกัด
- AI ออกแบบมาให้ไม่มีวันแพ้ ดังนั้นผู้เล่นจะชนะได้ก็ต่อเมื่อ AI ไม่มีทางเลือกอื่น ซึ่งเกิดขึ้นได้ยาก
- รองรับเฉพาะตาราง 3x3 ในเวอร์ชันปัจจุบัน

## เครดิต
พัฒนาโดยใช้แนวทางการออกแบบที่เน้นความยืดหยุ่นและประสิทธิภาพตามข้อกำหนดของ JavaScript Framework ที่มีโครงสร้างแบบโมดูล โดย xAI

## วันที่สร้าง
21 มีนาคม 2568 (March 21, 2025)

---

หากมีคำถามหรือต้องการปรับปรุงโปรเจ็กต์เพิ่มเติม แจ้งมาได้เลย!