# Thai Dessert Shop (เว็บไซต์ร้านขนมไทย)

เว็บไซต์ตัวอย่างสำหรับร้านขนมไทย — โครงงานแบบ static ที่ประกอบด้วย HTML, CSS, และ JavaScript (ไม่มี backend จริงในโค้ดต้นฉบับ: ข้อมูลตัวอย่างอยู่ในโฟลเดอร์ `mock/`).

## คำอธิบายสั้น ๆ

โปรเจ็คนี้เป็นเว็บไซต์หน้าร้านตัวอย่างสำหรับร้านขนมไทย (mock/demo). เหมาะสำหรับการสาธิต UI, การจัดการคำสั่งซื้อตัวอย่าง (mock data), และการทดลองกับ frontend logic เช่น POS และหน้าแอดมินแบบง่าย ๆ.

## โครงสร้างไฟล์ (สำคัญ)

- `index.html` — หน้าแรก (รายการสินค้า/หน้าแสดงผล)
- `admin.html` — หน้าแอดมิน (อาจมีฟีเจอร์จัดการ)
- `orders.html` — หน้าแสดงคำสั่งซื้อ
- `pos.html` — หน้าจอ POS สำหรับการขาย
- `css/` — ไฟล์สไตล์ (เช่น `styles.css`)
- `js/` — โค้ด JavaScript ของโปรเจ็ค
  - `app.js`, `components.js`, `db.js`, `pos.js`, `orders.js`, `admin.js` — สคริปต์ frontend ต่าง ๆ
- `images/` — รูปภาพสินค้าและแบนเนอร์
- `mock/` — ข้อมูลตัวอย่างในรูปแบบ JSON
  - `products.json`, `categories.json`, `orders.json`

## จุดประสงค์

- ตัวอย่างสำหรับการสร้าง storefront แบบ static
- โชว์การใช้งาน JavaScript ร่วมกับ JSON mock data
- ใช้เป็นฐานสำหรับขยายเป็นแอปที่มี backend/ฐานข้อมูลจริงในอนาคต

## วิธีรัน (ง่าย ๆ)

เว็บไซต์เป็น static file — คุณสามารถเปิด `index.html` โดยตรงในเบราว์เซอร์ได้ แต่เพื่อหลีกเลี่ยงปัญหา CORS เมื่อ fetch ไฟล์ `mock/*.json` แนะนำให้รันด้วย HTTP server แบบง่าย:

```bash
# Python 3
python3 -m http.server 8000
# แล้วเปิด http://localhost:8000 ในเบราว์เซอร์ (working directory ต้องเป็นโฟลเดอร์โปรเจ็ค)
```

หรือใช้ Node (http-server หรือ live-server):

```bash
# ถ้ามี npm ติดตั้ง
npx http-server -c-1 . 8000
# หรือ
npx live-server --port=8000
```

## พัฒนาและแก้ไข

- โค้ด frontend อยู่ใน `js/` — ดู `db.js` สำหรับการอ่าน/เขียนข้อมูลที่เชื่อมกับ `mock/*.json` (note: mock files เป็นไฟล์ static จึงไม่สามารถ "เขียน" ได้จาก browser จริง ๆ — การแก้ไขจำเป็นต้องทำบนฝั่งเซิร์ฟเวอร์หรือแก้ไฟล์ต้นฉบับใน repo)
- รูปภาพเก็บไว้ใน `images/` และไฟล์สไตล์ใน `css/styles.css`.

ข้อเสนอเพิ่มเติมถ้าจะขยายโปรเจ็ค:
- เพิ่ม backend (Express, Flask ฯลฯ) เพื่อให้ API สำหรับ CRUD ของสินค้าและคำสั่งซื้อ
- เปลี่ยน mock JSON เป็นฐานข้อมูลจริง (SQLite, PostgreSQL, MongoDB)
- เขียนชุดทดสอบ frontend เล็ก ๆ (เช่น Jest + jsdom ถ้าแยกเป็นโมดูล)

## ข้อจำกัดที่ควรทราบ

- ข้อมูลปัจจุบันเป็น mock JSON — ระบบไม่ได้เก็บคำสั่งซื้อแบบถาวร
- ไม่มีระบบล็อกอิน/สิทธิ์ผู้ใช้ (admin page อาจเปิดใช้งานโดยตรง)

## สิทธิ์ใช้งาน

ดูไฟล์ `LICENSE` ใน repository เพื่อดูข้อกำหนดลิขสิทธิ์
