// Complete meme templates collection - 21 templates
const memeTemplates = [
  {
    name: "Distracted Boyfriend",
    src: "img/templates/distracted-boyfriend.jpg",
    width: 1200,
    height: 800
  },
  {
    name: "Drake Pointing",
    src: "img/templates/drake-pointing.jpg",
    width: 1200,
    height: 1200
  },
  {
    name: "This Is Fine",
    src: "img/templates/this-is-fine.jpg",
    width: 580,
    height: 435
  },
  {
    name: "Expanding Brain",
    src: "img/templates/expanding-brain.jpg",
    width: 857,
    height: 1202
  },
  {
    name: "Two Buttons",
    src: "img/templates/two-buttons.jpg",
    width: 600,
    height: 908
  },
  {
    name: "Change My Mind",
    src: "img/templates/change-my-mind.jpg",
    width: 482,
    height: 361
  },
  {
    name: "Mocking SpongeBob",
    src: "img/templates/mocking-spongebob.jpg",
    width: 502,
    height: 353
  },
  {
    name: "Stonks",
    src: "img/templates/stonks.jpg",
    width: 680,
    height: 680
  },
  {
    name: "Woman Yelling at a Cat",
    src: "img/templates/woman-yelling-at-cat.jpg",
    width: 680,
    height: 438
  },
  {
    name: "Left Exit 12 Off Ramp",
    src: "img/templates/left-exit-12.jpg",
    width: 804,
    height: 767
  },
  {
    name: "UNO Draw 25",
    src: "img/templates/uno-draw-25.jpg",
    width: 500,
    height: 494
  },
  {
    name: "Panik Kalm Panik",
    src: "img/templates/panik-kalm-panik.jpg",
    width: 640,
    height: 881
  },
  {
    name: "Bernie Sanders I Am Once Again Asking",
    src: "img/templates/bernie-asking.jpg",
    width: 750,
    height: 750
  },
  {
    name: "Is This A Pigeon?",
    src: "img/templates/is-this-a-pigeon.jpg",
    width: 960,
    height: 720
  },
  {
    name: "Surprised Pikachu",
    src: "img/templates/surprised-pikachu.jpg",
    width: 1893,
    height: 1893
  },
  {
    name: "One Does Not Simply",
    src: "img/templates/one-does-not-simply.jpg",
    width: 568,
    height: 335
  },
  {
    name: "Futurama Fry",
    src: "img/templates/futurama-fry.jpg",
    width: 552,
    height: 414
  },
  {
    name: "Disaster Girl",
    src: "img/templates/disaster-girl.jpg",
    width: 500,
    height: 375
  },
  {
    name: "Success Kid",
    src: "img/templates/success-kid.jpg",
    width: 500,
    height: 500
  },
  {
    name: "Grumpy Cat",
    src: "img/templates/grumpy-cat.jpg",
    width: 500,
    height: 617
  },
  {
    name: "Always Has Been",
    src: "img/templates/always-has-been.jpg",
    width: 1600,
    height: 900
  },
  {
    name: "Hide the Pain Harold",
    src: "img/templates/hide-the-pain-harold.jpg",
    width: 480,
    height: 360
  }
];

// Load templates function
function loadTemplates() {
  const templatesContainer = document.querySelector('.templates');
  const templateCount = document.getElementById('template-count');

  if (!templatesContainer) {
    console.error('Templates container not found!');
    return;
  }

  templatesContainer.innerHTML = '';

  // Update template count
  if (templateCount) {
    templateCount.textContent = `${memeTemplates.length} เทมเพลต`;
  }

  memeTemplates.forEach((template, index) => {
    const templateDiv = document.createElement('div');
    templateDiv.className = 'template-item';
    templateDiv.innerHTML = `
      <img src="${template.src}" alt="${template.name}" loading="lazy">
      <div class="template-name">${template.name}</div>
    `;

    templateDiv.addEventListener('click', () => selectTemplate(template, templateDiv));
    templatesContainer.appendChild(templateDiv);
  });
}