# Smart Slip Verifier

ระบบตรวจสอบและดึงข้อมูลสลิปการโอนเงินแบบครบวงจร โดยใช้เทคโนโลยี QR Code Scanner และ OCR (Optical Character Recognition)

## ⚠️ คำเตือนสำคัญ

**โปรเจ็คนี้เป็นเพียงตัวอย่างการใช้งานเทคโนโลยี QR Scanner และ OCR เท่านั้น ไม่สามารถตรวจสอบสลิปจริงหรือไม่ได้ กรุณาใช้ระบบตรวจสอบที่เชื่อถือได้จากธนาคารหรือสถาบันการเงินโดยตรง**

## ✨ คุณสมบัติ

- 📱 **สแกน QR Code** - อ่านข้อมูลจาก QR Code ในสลิปการโอนเงิน
- 🔍 **OCR Processing** - ดึงข้อมูลข้อความจากรูปภาพสลิป
- 📷 **Image Preview** - แสดงตัวอย่างภาพที่อัพโหลด
- 🎯 **QR Crop Selector** - เลือกพื้นที่ QR Code เพื่อความแม่นยำ
- 📊 **Slip Parser** - แยกและจัดรูปแบบข้อมูลจากสลิป
- 🌐 **Web-based** - ใช้งานผ่านเว็บเบราว์เซอร์
- 📱 **Responsive Design** - รองรับการใช้งานบนมือถือและเดสก์ท็อป

## 🚀 Demo

### GitHub Pages
[https://goragodwiriya.github.io/smart-slip-verifier/](https://goragodwiriya.github.io/smart-slip-verifier/)

## 🛠️ เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างหน้าเว็บ
- **CSS3** - การตกแต่งและ Responsive Design
- **JavaScript (ES6+)** - Logic หลักของแอปพลิเคชัน
- **Tesseract.js** - OCR Engine สำหรับการอ่านข้อความ
- **QR Code Scanner** - ไลบรารีสำหรับสแกน QR Code
- **Bootstrap Icons** - ไอคอนสวยงาม
- **Google Fonts (Kanit)** - ฟอนต์ภาษาไทย

## 📦 การติดตั้งและใช้งาน

### วิธีที่ 1: ใช้งานผ่าน GitHub Pages
เข้าไปที่: [https://goragodwiriya.github.io/smart-slip-verifier/](https://goragodwiriya.github.io/smart-slip-verifier/)

### วิธีที่ 2: รันบนเครื่องของคุณ

1. **Clone Repository**
   ```bash
   git clone https://github.com/goragodwiriya/smart-slip-verifier.git
   cd smart-slip-verifier
   ```

2. **รันเซิร์ฟเวอร์ (เลือกวิธีใดวิธีหนึ่ง)**

   ใช้ Python:
   ```bash
   # Python 3
   python -m http.server 8000

   # หรือ Python 2
   python -m SimpleHTTPServer 8000
   ```

   ใช้ Node.js:
   ```bash
   npx http-server -p 8000
   ```

   ใช้ PHP:
   ```bash
   php -S localhost:8000
   ```

3. **เปิดเบราว์เซอร์**
   ```
   http://localhost:8000
   ```

## 📖 วิธีใช้งาน

1. **อัพโหลดรูปภาพ** - เลือกไฟล์รูปภาพสลิปการโอนเงิน
2. **เลือกโหมดการประมวลผล**:
   - 🔍 **QR Scanner** - สแกน QR Code อัตโนมัติ
   - 📝 **OCR Processing** - อ่านข้อความจากภาพ
   - 🎯 **Manual Crop** - เลือกพื้นที่ด้วยตนเอง
3. **ดูผลลัพธ์** - ระบบจะแสดงข้อมูลที่ดึงได้จากสลิป

## 📁 โครงสร้างโปรเจ็คต์

```
smart-slip-verifier/
├── index.html              # หน้าเว็บหลัก
├── package.json            # ข้อมูลโปรเจ็คต์
├── LICENSE                 # ใบอนุญาต
├── README.md              # เอกสารนี้
├── css/
│   └── styles.css         # ไฟล์ CSS หลัก
├── js/
│   ├── app.js             # ไฟล์ JavaScript หลัก
│   ├── ImagePreviewManager.js  # จัดการแสดงภาพ
│   ├── OCRProcessor.js    # ประมวลผล OCR
│   ├── QRCropSelector.js  # เลือกพื้นที่ QR
│   ├── QRScanner.js       # สแกน QR Code
│   ├── SlipParser.js      # แยกข้อมูลสลิป
│   └── SlipVerifier.js    # ตัวหลักของระบบ
└── test/                  # ไฟล์ทดสอบ
```

## 🌟 คุณสมบัติหลัก

### QR Code Scanner
- สแกน QR Code จากสลิปการโอนเงิน
- รองรับรูปแบบ QR Code ของธนาคารไทย
- ประมวลผลและแสดงข้อมูลในรูปแบบที่อ่านง่าย

### OCR Processing
- ใช้ Tesseract.js ในการอ่านข้อความ
- รองรับภาษาไทยและภาษาอังกฤษ
- ประมวลผลและจัดรูปแบบข้อมูล

### Image Management
- ตัวอย่างภาพก่อนประมวลผล
- เครื่องมือครอปรูปภาพ
- รองรับหลายรูปแบบไฟล์ (JPEG, PNG, WebP)

## 🔧 การพัฒนา

### ข้อกำหนดระบบ
- เบราว์เซอร์ที่รองรับ ES6+
- การเชื่อมต่ออินเทอร์เน็ต (สำหรับ CDN)

### การ Contribute
1. Fork โปรเจ็คต์
2. สร้าง Branch ใหม่ (`git checkout -b feature/amazing-feature`)
3. Commit การเปลี่ยนแปลง (`git commit -m 'Add amazing feature'`)
4. Push ไปยัง Branch (`git push origin feature/amazing-feature`)
5. สร้าง Pull Request

## 📝 License

โปรเจ็คต์นี้ใช้ลิขสิทธิ์ [MIT License](LICENSE)

## 👤 ผู้พัฒนา

**Goragod Wiriya**
- GitHub: [@goragodwiriya](https://github.com/goragodwiriya)
- Website: [https://www.kotchasan.com](https://www.kotchasan.com)

## 🔗 ลิงก์ที่เกี่ยวข้อง

- [GitHub Repository](https://github.com/goragodwiriya/smart-slip-verifier)
- [GitHub Pages Demo](https://goragodwiriya.github.io/smart-slip-verifier/)
- [Issues](https://github.com/goragodwiriya/smart-slip-verifier/issues)

---

<div align="center">

**⚠️ ข้อแนะนำ: โปรเจ็คต์นี้เป็นเพียงตัวอย่างการใช้งานเทคโนโลยี ไม่ควรใช้สำหรับการตรวจสอบสลิปจริงในเชิงพาณิชย์**

Made with ❤️ by [Goragod Wiriya](https://github.com/goragodwiriya)

</div>
