# โปรเจ็กต์หน้าเว็บโรงเรียนสาธิตแห่งความรู้

## ภาพรวม
หน้าเว็บโรงเรียนสาธิตแห่งความรู้เป็นเว็บแอปพลิเคชันที่พัฒนาด้วย **HTML**, **CSS**, และ **Vanilla JavaScript** โดยไม่มี Framework ภายนอก ออกแบบมาเพื่อแสดงข้อมูลของโรงเรียนในรูปแบบที่ทันสมัย ปลอดภัย และมีประสิทธิภาพสูง รองรับการใช้งานบนเดสก์ท็อปและอุปกรณ์มือถือ (Responsive Design) ใช้ Google Fonts (Prompt) และ Icomoon icons เพื่อความสวยงามและการใช้งานที่ง่าย

โปรเจ็กต์นี้ประกอบด้วยส่วนประกอบหลักดังนี้:
- **Hero Banner**: ส่วนต้อนรับที่มีภาพพื้นหลังและข้อความเชิญชวน
- **เกี่ยวกับโรงเรียน**: ข้อมูลแนะนำโรงเรียนพร้อมภาพประกอบ
- **แกลเลอรี**: Slideshow รูปภาพที่เลื่อนอัตโนมัติพร้อมปุ่มควบคุม
- **ผู้บริหาร**: รายชื่อผู้บริหารพร้อมรูปภาพและคำอธิบาย
- **กิจกรรม**: รายการกิจกรรมที่กำลังจะเกิดขึ้น
- **ประชาสัมพันธ์**: ข่าวสารและประกาศของโรงเรียน
- **ส่วนท้าย (Footer)**: ข้อมูลติดต่อและลิขสิทธิ์

## คุณสมบัติ
- **ความปลอดภัย**: ใช้ฟังก์ชัน `sanitizeHTML` เพื่อป้องกัน XSS (Cross-Site Scripting) โดยการกรองข้อมูลที่แสดงผล
- **ประสิทธิภาพ**: ออกแบบให้โหลดเร็วด้วย CSS ที่มีประสิทธิภาพและการจัดการรูปภาพแบบ Lazy Loading (สามารถเพิ่มได้)
- **Responsive Design**: รองรับการแสดงผลบนหน้าจอทุกขนาดด้วย CSS Grid และ Media Queries
- **Slideshow อัตโนมัติ**: แกลเลอรีเลื่อนภาพทุก 5 วินาที พร้อมปุ่มถัดไป/ย้อนกลับและจุดนำทาง
- **การจัดการข้อผิดพลาด**: รูปภาพที่โหลดไม่สำเร็จจะถูกแทนที่ด้วย placeholder หรือข้อความแจ้งเตือน
- **การนำทางราบรื่น**: เมนูนำทางที่เลื่อนไปยังส่วนต่างๆ ของหน้าเว็บด้วย `scrollIntoView`

## การติดตั้งและใช้งาน
1. **ดาวน์โหลดไฟล์**:
   - คัดลอกไฟล์ `index.html` จากโปรเจ็กต์นี้
2. **รันในเบราว์เซอร์**:
   - เปิดไฟล์ `index.html` ในเบราว์เซอร์ที่รองรับ (เช่น Chrome, Firefox, Safari)
   - ไม่จำเป็นต้องติดตั้งเซิร์ฟเวอร์ เนื่องจากใช้ทรัพยากรออนไลน์ (Google Fonts, Icomoon, Unsplash)
3. **ปรับแต่งข้อมูล**:
   - แก้ไขข้อมูลในตัวแปร JavaScript (`executivesData`, `activitiesData`, `newsData`) เพื่อเปลี่ยนชื่อ รูปภาพ หรือคำอธิบาย
   - แก้ไข URL รูปภาพในส่วนแกลเลอรีหรือ Hero Banner เพื่อใช้รูปภาพของโรงเรียนจริง

## เทคโนโลยีที่ใช้
- **HTML5**: โครงสร้างหน้าเว็บ
- **CSS3**: การออกแบบและ Responsive Design
- **Vanilla JavaScript**: การจัดการ DOM และการทำงานของ Slideshow
- **Google Fonts (Prompt)**: ฟอนต์ภาษาไทยที่สวยงามและอ่านง่าย
- **Icomoon Icons**: ไอคอนที่ใช้ในส่วนต่างๆ เช่น ผู้บริหาร, กิจกรรม, และประชาสัมพันธ์
- **Unsplash**: แหล่งรูปภาพสาธารณะสำหรับตัวอย่าง

## สิ่งที่สามารถปรับปรุงได้
เพื่อให้โปรเจ็กต์นี้สมบูรณ์ยิ่งขึ้นและรองรับการใช้งานในอนาคต สามารถพัฒนาเพิ่มเติมในด้านต่อไปนี้:
1. **การโหลดรูปภาพแบบ Lazy Loading**:
   - เพิ่ม `loading="lazy"` ในแท็ก `<img>` เพื่อลดเวลาโหลดหน้าเว็บ
   - ใช้ Intersection Observer API เพื่อโหลดรูปภาพเฉพาะเมื่ออยู่ในมุมมอง
2. **การจัดการข้อมูลแบบ Dynamic**:
   - เพิ่มการเชื่อมต่อกับ API หรือฐานข้อมูล (เช่น JSON หรือ CMS) เพื่ออัปเดตข้อมูลผู้บริหาร, กิจกรรม, และข่าวสารโดยไม่ต้องแก้โค้ด
3. **การเข้าถึง (Accessibility)**:
   - เพิ่ม ARIA attributes เพื่อรองรับผู้ใช้ที่ใช้ Screen Reader
   - ปรับปรุงคอนทราสต์สีและขนาดตัวอักษรให้เหมาะสมตาม WCAG
4. **การเพิ่มประสิทธิภาพ SEO**:
   - เพิ่ม meta tags เช่น `og:image` และ `og:description` สำหรับการแชร์บนโซเชียลมีเดีย
   - สร้าง sitemap และ robots.txt สำหรับการค้นหา
5. **การจัดการแกลเลอรี**:
   - เพิ่มคำอธิบาย (caption) สำหรับแต่ละภาพในแกลเลอรี
   - รองรับการซูมภาพหรือการแสดงแบบเต็มหน้าจอ
6. **การเพิ่มฟังก์ชันการโต้ตอบ**:
   - เพิ่มฟอร์มติดต่อในส่วน Footer เพื่อให้ผู้ใช้ส่งข้อความถึงโรงเรียน
   - เพิ่มการแจ้งเตือน (modal) สำหรับข่าวสารสำคัญ
7. **การจัดการข้อผิดพลาดขั้นสูง**:
   - เพิ่มการตรวจสอบและแจ้งเตือนเมื่อ URL รูปภาพทั้งหมดโหลดไม่สำเร็จ
   - ใช้ CDN ที่น่าเชื่อถือสำหรับรูปภาพเพื่อลดปัญหาการโหลด
8. **การแปลภาษา**:
   - เพิ่มการรองรับหลายภาษา (เช่น อังกฤษ) สำหรับผู้ใช้ต่างชาติ
9. **การปรับแต่ง UI**:
   - เพิ่มแอนิเมชันที่ซับซ้อนมากขึ้นในส่วน Hero Banner หรือ Slideshow
   - ปรับแต่งสีและธีมให้ตรงกับอัตลักษณ์ของโรงเรียน

## ผู้แต่ง
- **Goragod Wiriya**: ผู้ริเริ่มและกำหนดแนวคิดของโปรเจ็กต์
- **AI Grok**: พัฒนาและเขียนโค้ดโดย Grok สร้างโดย xAI

## หมายเหตุ
- โปรเจ็กต์นี้เหมาะสำหรับการใช้งานในระดับ Production ด้วยการออกแบบที่เรียบง่ายและปลอดภัย แต่ควรทดสอบในสภาพแวดล้อมจริงก่อนนำไปใช้