# โรงเรียนเทมเพลต | School Template Calendar

> **โปรเจ็คเว็บไซต์เทมเพลตโรงเรียนที่สวยงามและใช้งานง่าย**

## 📋 รายละเอียดโปรเจ็ค

เว็บไซต์เทมเพลตโรงเรียนที่ออกแบบมาเพื่อใช้เป็นแม่แบบสำหรับสถานศึกษา มีส่วนประกอบครบครันและดีไซน์ที่ทันสมัย

### ✨ คุณสมบัติหลัก

- **🎨 ดีไซน์ที่ทันสมัย** - ใช้ Tailwind CSS และ Font Awesome
- **📱 Responsive Design** - รองรับทุกขนาดหน้าจอ
- **📅 ปฏิทินกิจกรรม** - ระบบปฏิทินสำหรับแสดงกิจกรรมโรงเรียน
- **📰 ข่าวสาร** - ส่วนแสดงข่าวสารและประกาศ
- **🖼️ แกลเลอรี่** - ส่วนแสดงภาพกิจกรรมต่างๆ
- **📞 ติดต่อ** - ข้อมูลติดต่อและแบบฟอร์ม

### 📄 ไฟล์ในโปรเจ็ค

- `index.html` - หน้าแรกของเว็บไซต์โรงเรียน

## 🚀 การใช้งาน

### การติดตั้ง

1. ดาวน์โหลดไฟล์โปรเจ็ค
2. แตกไฟล์ลงในเว็บเซิร์ฟเวอร์
3. เปิดไฟล์ `index.html` ในเบราว์เซอร์

### การปรับแต่ง

1. **การแก้ไขข้อมูลโรงเรียน**
   - แก้ไขชื่อโรงเรียนในไฟล์ HTML
   - เปลี่ยนโลโก้และรูปภาพ
   - อัปเดตข้อมูลติดต่อ

2. **การปรับแต่งสี**
   - แก้ไขสีในส่วน CSS Variables
   - ปรับแต่งสีใน Tailwind Classes

3. **การเพิ่มเนื้อหา**
   - เพิ่มข่าวสารในส่วน News Section
   - อัปเดตปฏิทินกิจกรรม
   - เพิ่มภาพในแกลเลอรี่

## 🛠️ เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างเว็บไซต์
- **CSS3** - การจัดรูปแบบ
- **JavaScript** - ฟังก์ชันโต้ตอบ
- **Font Awesome** - ไอคอน
- **Google Fonts** - ฟอนต์ภาษาไทย (Kanit)

## 📱 ส่วนประกอบของเว็บไซต์

### หน้าแรก (index.html)
- **Hero Section** - ส่วนแรกที่ดึงดูดสายตา
- **Quick Links** - ลิงก์ด่วนไปยังระบบต่างๆ
- **About Section** - เกี่ยวกับโรงเรียน
- **News Section** - ข่าวสารล่าสุด
- **Footer** - ข้อมูลติดต่อ

### หน้าปฏิทิน (index-calendar.html)
- **Navigation** - แถบเมนูนำทาง
- **Hero Section** - ส่วนแรกของหน้า
- **About Section** - ประวัติโรงเรียน
- **Calendar Section** - ปฏิทินกิจกรรม
- **News Section** - ข่าวสารและประกาศ
- **Gallery Section** - ภาพกิจกรรมต่างๆ
- **Contact Section** - ข้อมูลติดต่อ

## 🎨 การปรับแต่งดีไซน์

### สีหลัก
- **Primary**: Blue (#2563eb)
- **Secondary**: Green (#10b981)
- **Accent**: Yellow (#f59e0b)

### ฟอนต์
- **ภาษาไทย**: Kanit (Google Fonts)
- **ภาษาอังกฤษ**: System Font Stack

## 👥 ผู้พัฒนา

- **ผู้แต่ง**: Goragod Wiriya
- **AI Assistant**: Claude
- **ภาษา**: Thai/English
- **ลิขสิทธิ์**: MIT License

## 📝 หมายเหตุ

- โปรเจ็คนี้เป็นเทมเพลตสำหรับโรงเรียน สามารถนำไปปรับใช้ได้ตามต้องการ
- รูปภาพใช้จาก Unsplash และเป็นตัวอย่างเท่านั้น
- ควรเปลี่ยนรูปภาพและข้อมูลให้เหมาะสมกับโรงเรียนของคุณ

## 🔧 การพัฒนาต่อยอด

- เชื่อมต่อกับฐานข้อมูล
- เพิ่มระบบจัดการเนื้อหา (CMS)
- เพิ่มระบบล็อกอิน
- เพิ่มระบบการสมัครออนไลน์
- เพิ่มระบบแจ้งเตือน

---

**🌟 ขอบคุณที่ใช้งาน School Template Calendar! 🌟**