# 🤖 Prompt สำหรับสร้างโปรเจ็ค School Template Calendar

## 📝 Prompt หลักสำหรับการสร้างโปรเจ็ค

```
สร้างเว็บไซต์เทมเพลตโรงเรียนที่สวยงามและครบครันสำหรับสถานศึกษา โดยมีคุณสมบัติดังนี้:

### 🎯 เป้าหมาย
- สร้างเว็บไซต์เทมเพลตสำหรับโรงเรียนที่ทันสมัยและใช้งานง่าย
- ออกแบบให้เหมาะสำหรับโรงเรียนภาษาไทย
- รองรับการใช้งานทั้งในคอมพิวเตอร์และมือถือ

### 📋 ไฟล์ที่ต้องสร้าง
1. `index.html` - หน้าแรกของเว็บไซต์

### 🎨 ดีไซน์และสี
- ใช้โทนสีน้ำเงิน (Blue) เป็นหลัก
- สีเสริม: เขียว (Green) และเหลือง (Yellow)
- ดีไซน์ที่ทันสมัย มีการใช้ gradient และ shadow
- Typography ใช้ฟอนต์ Kanit สำหรับภาษาไทย

### 🛠️ เทคโนโลยี
- HTML5 และ CSS3
- Tailwind CSS สำหรับ styling
- Font Awesome สำหรับ icons
- JavaScript สำหรับ interactivity
- Google Fonts (Kanit) สำหรับภาษาไทย

### 📱 ส่วนประกอบ index.html
1. **Top Bar** - แถบบนสุดแสดงข้อมูลติดต่อ
2. **Navigation** - แถบเมนูนำทาง
3. **Hero Section** - ส่วนแรกที่ดึงดูดสายตา
4. **Quick Links** - ลิงก์ด่วนไปยังระบบต่างๆ (ปฏิทิน, E-Learning, ผลการเรียน, รถโรงเรียน)
5. **About Section** - เกี่ยวกับโรงเรียน
6. **News Section** - ข่าวสารล่าสุด
7. **Footer** - ข้อมูลติดต่อและลิงก์ต่างๆ

### 📅 ส่วนประกอบ index-calendar.html
1. **Header** - แถบเมนูนำทาง
2. **Hero Section** - ส่วนแรกของหน้า
3. **About Section** - ประวัติโรงเรียน พร้อมสถิติ
4. **Calendar Section** - ปฏิทินกิจกรรมแบบปี (12 เดือน)
5. **News Section** - ข่าวสารและประกาศ
6. **Gallery Section** - ภาพกิจกรรมต่างๆ
7. **Contact Section** - ข้อมูลติดต่อ

### 🎯 คุณสมบัติพิเศษ
- Responsive design ทำงานได้ดีในทุกขนาดหน้าจอ
- Animation และ hover effects ที่สวยงาม
- ปฏิทินแบบปีที่แสดง 12 เดือน
- Card-based layout สำหรับข่าวสารและกิจกรรม
- Modern UI/UX design patterns

### 📝 เนื้อหาตัวอย่าง
- ใช้ข้อมูลตัวอย่างเป็นภาษาไทย
- รูปภาพจาก Unsplash (การศึกษา/โรงเรียน)
- ข้อมูลติดต่อจำลอง

### 🔧 ความต้องการเพิ่มเติม
- Code ต้องสะอาดและมีการ comment
- ปรับปรุงได้ง่าย
- ใช้ semantic HTML
- เพิ่ม meta tags สำหรับ SEO
- ใช้ CSS custom properties สำหรับสี
```

## 🎯 Prompt เฉพาะส่วน

### 1. สำหรับหน้าแรก (index.html)
```
สร้างหน้าแรกของเว็บไซต์โรงเรียนที่ชื่อ "โรงเรียนดิจิทัล" ให้มีส่วนประกอบครบครันดังนี้:

- Top bar แสดงข้อมูลติดต่อและลิงก์เข้าสู่ระบบ
- Navigation bar สีขาวทึบแสง
- Hero section ใช้รูปพื้นหลังโรงเรียน
- Quick links เป็น grid 4 ช่อง (ปฏิทิน, E-Learning, ผลการเรียน, รถโรงเรียน)
- About section แสดงข้อมูลโรงเรียน
- News section แสดงข่าวสารล่าสุด
- Footer ครบครัน

ใช้ Tailwind CSS และ Font Awesome สำหรับไอคอน
```

### 2. สำหรับหน้าปฏิทิน (index-calendar.html)
```
สร้างหน้าปฏิทินกิจกรรมของเว็บไซต์โรงเรียนที่ชื่อ "โรงเรียนสาธิตพัฒนา" ให้มีส่วนประกอบดังนี้:

- Header พร้อมโลโก้และเมนูนำทาง
- Hero section พร้อมปุ่ม CTA
- About section พร้อมสถิติโรงเรียน
- Calendar section แสดงปฏิทิน 12 เดือน
- News section แสดงข่าวสาร 3 รายการ
- Gallery section แสดงภาพกิจกรรม
- Contact section พร้อมข้อมูลติดต่อและแผนที่

ใช้ฟอนต์ Kanit และมี JavaScript สำหรับปฏิทิน
```

## 🎨 Prompt สำหรับการปรับแต่ง

### การปรับแต่งสี
```
ปรับสีของเว็บไซต์ให้เป็นโทนสี [ระบุสี] โดยแก้ไขใน:
- CSS custom properties
- Tailwind classes
- Background gradients
- Hover effects
```

### การเพิ่มเนื้อหา
```
เพิ่มส่วน [ระบุส่วน] ในเว็บไซต์โรงเรียน โดยให้มีการออกแบบที่เข้ากับโครงสร้างเดิม และใช้ Tailwind CSS
```

### การปรับแต่งปฏิทิน
```
ปรับปฏิทินให้สามารถ:
- เพิ่มกิจกรรมในวันต่างๆ
- เปลี่ยนปี/เดือน
- แสดงรายละเอียดกิจกรรม
- ใช้สีที่แตกต่างกันสำหรับประเภทกิจกรรม
```

## 🔧 Prompt สำหรับการพัฒนาต่อยอด

### การเชื่อมต่อฐานข้อมูล
```
แปลงเว็บไซต์โรงเรียนเป็น dynamic โดยเชื่อมต่อกับฐานข้อมูล MySQL และใช้ PHP สำหรับ backend
รองรับการจัดการ:
- ข่าวสาร
- กิจกรรม
- ภาพแกลเลอรี่
- ข้อมูลโรงเรียน
```

### การเพิ่มระบบจัดการ
```
เพิ่มระบบจัดการเนื้อหา (CMS) สำหรับ:
- จัดการข่าวสาร
- จัดการกิจกรรม
- จัดการรูปภาพ
- จัดการเมนู
- ระบบสมาชิก
```

## 📚 ข้อมูลอ้างอิง

### Resources ที่ใช้
- Tailwind CSS: https://tailwindcss.com
- Font Awesome: https://fontawesome.com
- Google Fonts: https://fonts.google.com
- Unsplash: https://unsplash.com (สำหรับรูปภาพ)

### Best Practices
- ใช้ semantic HTML
- เพิ่ม alt text สำหรับรูปภาพ
- ทำให้ accessible
- ใช้ meta tags ที่ถูกต้อง
- ปรับปรุงประสิทธิภาพ (Performance)

---

> **หมายเหตุ**: Prompt นี้สร้างขึ้นเพื่อช่วยในการพัฒนาเว็บไซต์เทมเพลตโรงเรียนที่คล้ายกับโปรเจ็คนี้