<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$path = __DIR__.'/storage/store.json';
if (!file_exists($path)) {
    echo json_encode(['ok' => false, 'error' => 'No store saved']);
    exit;
}

$json = file_get_contents($path);
$data = json_decode($json, true);
if ($data === null) {
    echo json_encode(['ok' => false, 'error' => 'Invalid store file']);
    exit;
}

echo json_encode(['ok' => true, 'data' => $data], JSON_UNESCAPED_UNICODE);
