<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

// TODO: ดึงจากฐานข้อมูล MySQL แทน (ตัวอย่างไฟล์เก็บในโฟลเดอร์ storage)
$dir = __DIR__.'/storage';
@mkdir($dir);
$files = glob($dir.'/*.json');
$list = [];
foreach ($files as $f) {
    $json = json_decode(file_get_contents($f), true);
    if ($json) {
        $list[] = ['id' => $json['id'] ?? basename($f, '.json'), 'ts' => $json['ts'] ?? filemtime($f)];
    }

}
usort($list, function ($a, $b) {return ($b['ts'] ?? 0) <=> ($a['ts'] ?? 0);});
echo json_encode(['ok' => true, 'receipts' => $list], JSON_UNESCAPED_UNICODE);
