# Receipt Builder

โปรเจ็คนี้เป็นเว็บแอปเล็ก ๆ สำหรับจัดการบันทึกใบเสร็จ (receipts) โดยใช้ HTML/CSS/JavaScript เป็นหน้า frontend และมี endpoint แบบ PHP อยู่ในโฟลเดอร์ `api/` สำหรับจัดเก็บและดึงข้อมูลใบเสร็จ

## คุณสมบัติหลัก
- ออกแบบใบเสร็จด้วยการลากวางคอมโพเนนต์ (หัวข้อ, ข้อความ, โลโก้, ตารางรายการสินค้า, สรุปยอด, Barcode / QR PromptPay ฯลฯ)
- บันทึกและโหลด "Template" ของเลย์เอาต์
- จัดการข้อมูลร้าน (ชื่อ, สาขา, ที่อยู่, เบอร์, เลขผู้เสียภาษี, PromptPay ID, โลโก้)
- เพิ่ม/แก้ไขรายการสินค้าในใบเสร็จ
- นำเข้า/ส่งออกข้อมูลเป็นไฟล์ JSON
- บันทึกใบเสร็จลง local storage และสามารถเรียกดูรายการใบเสร็จจาก `api/` (ไฟล์ JSON ใน `api/storage/`)
- พิมพ์ด้วยฟังก์ชัน `window.print()` (ปุ่ม "พิมพ์")

## สแต็กและไลบรารีที่ใช้ (frontend)
- Vanilla JavaScript (โมดูลต่าง ๆ อยู่ใน `js/`)
- SortableJS (ลาก-วาง และจัดเรียงคอมโพเนนต์)
- JsBarcode (สร้าง barcode)
- qrcode (สร้าง QR code)
- Font Awesome (ไอคอน)

CDN ที่หน้า `index.html` โหลด:
- https://cdn.jsdelivr.net/npm/sortablejs
- https://cdn.jsdelivr.net/npm/jsbarcode
- https://cdn.jsdelivr.net/npm/qrcode
- https://cdnjs.cloudflare.com/ajax/libs/font-awesome

## โครงสร้างไฟล์สำคัญ
- `index.html` — หน้า UI หลัก
- `css/style.css` — สไตล์ของแอป
- `js/` — โค้ดฝั่งไคลเอนต์
  - `app.js` — โลจิกเริ่มต้น, ปุ่ม toolbar, การเชื่อม UI
  - `components.js` — การเรนเดอร์คอมโพเนนต์ใบเสร็จ
  - `templates.js` — เก็บ/เรียกใช้เทมเพลต
  - `state.js` — สถานะแอป (Pro global object)
  - `storage.js` — ฟังก์ชันเก็บ/โหลดใบเสร็จ, import/export
  - `items.js` — จัดการรายการสินค้า
  - `properties.js` — แก้ไข property ของคอมโพเนนต์
  - `print.js` — ฟังก์ชันการพิมพ์ (เรียก window.print())
- `api/` — endpoint แบบ PHP (ตัวอย่างการจัดเก็บแบบไฟล์)
  - `get_store.php` — GET: คืนค่า `api/storage/store.json` (ข้อมูลร้าน/ตั้งค่า)
  - `save_store.php` — POST: บันทึก JSON payload ลง `api/storage/store.json`
  - `list_receipts.php` — GET: คืนรายการใบเสร็จจากไฟล์ JSON ใน `api/storage/`
  - `save_receipt.php` — (มีในโฟลเดอร์) ตัวอย่างการบันทึกใบเสร็จ (เรียกจาก frontend เมื่อบันทึก)
  - `upload_logo.php` — (ตัวอย่าง) รองรับการอัพโหลดไฟล์โลโก้เป็น multipart/form-data (สาธิตแบบจำกัด/ปิดใช้งานในตัวอย่าง)
  - `storage/` — โฟลเดอร์ที่เก็บ `store.json` และไฟล์ใบเสร็จ `.json`

## รูปแบบการเก็บข้อมูลและ API (สรุป)
- `GET api/get_store.php` — อ่านไฟล์ `api/storage/store.json`
  - ตัวอย่างตอบกลับ:
    {
      "ok": true,
      "data": {
        "store": { "name": "...", "logoUrl": "...", ... },
        "vatRate": 7
      }
    }

- `POST api/save_store.php` — รับ JSON payload และเขียนทับ `api/storage/store.json`
  - ควรส่ง Content-Type: application/json
  - ตัวอย่าง payload: { "store": { ... }, "vatRate": 7 }

- `GET api/list_receipts.php` — คืนรายการใบเสร็จจากไฟล์ JSON ใน `api/storage/` (อ่านทุกไฟล์ .json ในโฟลเดอร์นั้น)
  - ตัวอย่างตอบกลับ: { "ok": true, "receipts": [ {"id":"r1","ts": 167...}, ... ] }

- `POST api/save_receipt.php` — (frontend อาจเรียกเพื่อบันทึกบนเซิร์ฟเวอร์) — ดูโค้ด `js/storage.js`/`app.js` เพื่อรูปแบบ payload ที่ส่ง (โดยค่าเริ่มต้นโค้ดบันทึกลง client storage และมีตัวอย่างที่บันทึกเป็นไฟล์ใน `api/storage/`).

- `POST api/upload_logo.php` — รองรับ multipart form upload ของไฟล์ภาพ (field name `file`). ในตัวอย่างการอัพโหลดบางส่วนถูกปิด/คอมเมนต์ไว้และฟังก์ชัน fallback จะให้ frontend บันทึกเป็น dataURL (local) หากเซิร์ฟเวอร์ไม่รองรับการเขียนไฟล์

## การติดตั้งและรัน (เดโม่ / พัฒนา)
1. เปิด terminal เข้าไปที่โฟลเดอร์โปรเจ็ค:

```bash
cd /path/to/receipt-builder
```

2. รัน PHP built-in server (สำหรับการทดสอบ):

```bash
php -S localhost:8000
```

3. เปิดเบราว์เซอร์ที่:

http://localhost:8000/index.html

หรือวางโปรเจ็คใน DocumentRoot/VirtualHost ของ Apache/Nginx ที่มี PHP (PHP 7+)

## การใช้งานหลัก (quick guide)
- ลากคอมโพเนนต์จากแผงซ้ายมาวางที่พื้นที่ canvas
- ปรับ properties ทางแผงขวา (ข้อมูลร้าน, ข้อมูลใบเสร็จ, VAT)
- กด "บันทึกใบเสร็จ" เพื่อบันทึก (จะบันทึกลง local storage และเรียก UI ให้แสดงรายการ)
- กด "พิมพ์" เพื่อพิมพ์ผ่าน dialog ของเบราว์เซอร์
- ใช้ปุ่ม Import/Export เพื่อนำเข้า/ส่งออก JSON
- บันทึก Template: กดปุ่ม "บันทึก Template" แล้วตั้งชื่อเพื่อเรียกใช้ซ้ำ

## ข้อสังเกตและข้อจำกัดปัจจุบัน
- ไฟล์ใน `api/` เป็นตัวอย่างแบบไฟล์ (file-based). สำหรับ production ควรเปลี่ยนไปใช้ฐานข้อมูล เช่น MySQL/SQLite และเพิ่มการตรวจสอบสิทธิ์/validation
- `upload_logo.php` ตัวอย่างการอัพโหลดถูกคอมเมนต์/จำกัดอยู่บางส่วน (demo). โค้ด frontend มี fallback ที่อ่านไฟล์เป็น dataURL และเก็บใน localStorage หากการอัพโหลดเซิร์ฟเวอร์ล้มเหลว
- frontend จะพยายามโหลดข้อมูลร้านจาก `api/get_store.php` (server) และจะผสานกับค่าที่อยู่ใน localStorage — server ถูกมองว่าเป็น authoritative สำหรับการตั้งค่ากลาง
- โค้ดในโปรเจ็คนี้ปิดการใช้งานการบันทึกข้อมูลลงเซิร์ฟเวอร์ หากต้องการนำไปใช้จริง อาจต้องตรวจสอบและเปิดใช้งานส่วนที่เกี่ยวข้องใน `api`

## การแก้ปัญหาเบื้องต้น
- หากหน้าจอไม่แสดงอะไร: เปิด DevTools ดูข้อผิดพลาด JS และเช็กว่ามีการโหลดไฟล์ `js/*.js` ถูกต้อง
- หาก API คืนค่า 500/ไม่พบ: ตรวจสอบ permission ของ `api/storage/` และ log ของ PHP/เว็บเซิร์ฟเวอร์
