# Goragod Wiriya — Portfolio (GrapesJS)

ผู้แต่ง: Goragod Wiriya

โปรเจ็คนี้เป็นเว็บไซต์พอร์ตโฟลิโอแบบสแตติกที่สร้าง/แก้ไขด้วย GrapesJS (AI-assisted) และปรับแต่งโดย Goragod Wiriya.

## ภาพรวม
- ไฟล์หลัก: `index.html`, `style.css`
- จุดประสงค์: พอร์ตโฟลิโอส่วนตัวสำหรับแสดงโปรเจ็ค, วิธีติดต่อ และข้อมูลผู้แต่ง
- เครื่องมือที่ใช้: HTML/CSS (ออกแบบ/แก้ไขด้วย GrapesJS)

## โครงสร้างไฟล์สำคัญ
- `index.html` — เพจหลักของเว็บไซต์
- `style.css` — สไตล์ของเว็บไซต์
- `resume_goragod.pdf` — (placeholder) ลิงก์ดาวน์โหลดเรซูเม่ (ถ้ายังไม่มี ให้เพิ่มไฟล์นี้ใน root)

## รันแบบโลคัล (วิธีง่าย)
เว็บไซต์เป็นไฟล์สแตติก สามารถรันด้วย static server เช่น Python HTTP server หรือ serve ด้วย Node.js

ตัวอย่าง (Python 3):

```bash
# เปิดพอร์ต 8000 แล้วเข้า http://localhost:8000
cd /path/to/project/portfolio-grapesjs
python3 -m http.server 8000
```

ตัวอย่าง (Node.js + serve):

```bash
npm install -g serve
cd /path/to/project/portfolio-grapesjs
serve -s .
```

## แก้ไขเนื้อหา
- แก้ไขเนื้อหาหลักและโครงสร้างใน `index.html` (หัวข้อ, ข้อมูลติดต่อ, ลิงก์โปรเจ็ค)
- แก้ไขลักษณะ/ธีมใน `style.css` (ตัวแปรสี เองใช้ `--gw-...` prefix)

แนะนำ workflow:
1. แก้ `index.html` และ `style.css` ใน editor (VS Code)
2. เปิดเบราว์เซอร์ดูการเปลี่ยนแปลงด้วย static server

## ปรับแต่งเพิ่มเติม (ข้อเสนอแนะ)
- เพิ่ม `resume_goragod.pdf` ใน root หรือเปลี่ยนลิงก์เรซูเม่ใน `index.html`
- แก้ลิงก์ repo/demo ให้ชี้ไปยังโปรเจ็คจริงของคุณ (ตอนนี้เป็น placeholder)
- เพิ่ม meta tags (Open Graph) เพื่อแชร์บน social preview
- ตรวจสอบ accessibility (a11y) และ performance (Lighthouse)

## ดีพลอย (ตัวเลือก)
- Deploy บน Netlify / Vercel / GitHub Pages — เพียง push repo แล้วชี้โฟลเดอร์ `port` เป็น root ของเว็บ

## ติดต่อ
- อีเมล: goragod@wiriya.dev
- GitHub: https://github.com/goragod
- LinkedIn: https://www.linkedin.com/in/goragodwiriya

---

หากต้องการให้ผมเพิ่มไฟล์ README เป็นภาษาอังกฤษ, เพิ่มตัวอย่างการ deploy แบบ CI/CD หรือสร้าง `resume_goragod.pdf` placeholder ให้ บอกมาได้เลยครับ