# 🎄 AI Christmas Landing Page Showcase

โปรเจ็คนี้รวบรวม Landing Page สำหรับเทศกาล **คริสต์มาส และปีใหม่** ที่ออกแบบโดย AI จากค่ายต่างๆ

## 🎯 Prompt ที่ใช้

> **"Create a beautiful, modern Christmas and New Year landing page with animations HTML + Javascript google font"**

## 🤖 AI Models

| AI Model | Folder | Description |
|----------|--------|-------------|
| **Claude** (Anthropic) | `/claude` | Dancing Script font, elegant design with floating snowflakes |
| **Gemini** (Google) | `/gemini` | GSAP animations, canvas snow, glassmorphism cards |
| **GLM** (Zhipu AI) | `/glm` | Full-featured with music player, newsletter, countdown |
| **GPT** (OpenAI) | `/gpt` | Modern card design, Web Audio cheer, ornament animations |
| **Grok** (xAI) | `/grok` | Minimalist, tree with ornaments, firework celebration |

## 📁 โครงสร้างโปรเจ็ค

```
christmas_theme/
├── index.html          # Landing page (showcase)
├── README.md           # ไฟล์นี้
├── claude/
│   └── index.html      # Claude's design
├── gemini/
│   └── index.html      # Gemini's design
├── glm/
│   └── index.html      # GLM's design
├── gpt/
│   └── index.html      # GPT's design
└── grok/
    └── index.html      # Grok's design
```

## ✨ Features ที่พบในแต่ละตัวอย่าง

- 🌨️ **Snow Effects** - หิมะตกแบบ CSS หรือ Canvas
- ⏱️ **Countdown Timer** - นับถอยหลังสู่ปีใหม่
- 🎵 **Music Player** - เล่นเพลงประกอบ (GLM)
- 🎆 **Animations** - GSAP, CSS keyframes, requestAnimationFrame
- 📱 **Responsive** - รองรับทุกขนาดหน้าจอ
- 🎨 **Google Fonts** - Dancing Script, Mountains of Christmas, Poppins, etc.

## 🚀 วิธีใช้งาน

1. เปิด `index.html` เพื่อดู showcase ทั้งหมด
2. คลิกเลือก AI ที่ต้องการดูตัวอย่าง
3. เปรียบเทียบ design และ features ของแต่ละ AI

## 📝 License

MIT License - ใช้งานได้อย่างอิสระ 🎁

---

**Made with ❤️ for the Holiday Season 2024-2025** 🎅✨
