# 🎯 ระบบวิเคราะห์หวยไทย (Thairath Analyzer)

> ผู้แต่ง: **Goragod Wiriya**

## 📢 ข้อมูลหวยมาจากไหน?
- ระบบนี้ดึงข้อมูลผลสลากกินแบ่งรัฐบาลไทย **100% จากเว็บไซต์ไทยรัฐ** ([https://www.thairath.co.th/lottery](https://www.thairath.co.th/lottery))
- ข้อมูลย้อนหลัง 50 งวด ดึงจากหน้าสถิติไทยรัฐ ([https://www.thairath.co.th/lottery/statistics](https://www.thairath.co.th/lottery/statistics))
- **ข้อควรระวัง:** ข้อมูลนี้ใช้เพื่อการศึกษา/ตัวอย่างเท่านั้น ไม่ควรใช้เพื่อการพนันหรืออ้างอิงผลรางวัลจริง และใช้เป็นตัวอย่างการ scrape ข้อมูลเท่านั้น ไม่ได้มีการใช้งานจริง

## ✨ คุณสมบัติ
- 📊 **วิเคราะห์สถิติหวยย้อนหลัง** จากข้อมูลจริง (raw data) ของไทยรัฐ
- 🔥 **เลขเด่น/กราฟ/สถิติ** คำนวณและแสดงผลโดย JavaScript ฝั่ง frontend เท่านั้น
- 💾 **ระบบ Cache** (ไฟล์ `api/lottery_cache.json`) เพื่อประหยัด request และโหลดเร็ว
- 🌐 **API Endpoint** สำหรับใช้งานกับ JavaScript (ไม่มี logic วิเคราะห์ใน backend)
- 🟢 **Auto Update Cache** อัตโนมัติเมื่อเข้าเงื่อนไข (ดูด้านล่าง)
- 🖥️ **GitHub Pages** สามารถ deploy หน้าเว็บตัวอย่างได้ทันที

## 🚦 Logic ระบบ Cache & Auto Update
- **Frontend** จะโหลดข้อมูลจาก `api/lottery_cache.json` ทุกครั้ง
- ถ้าไม่พบ cache หรือ cache เก่า (ดูด้านล่าง) จะ trigger `api/update_cache.php` เพื่อ scrape ข้อมูลใหม่
- **Auto update cache** จะเกิดขึ้นเมื่อ:
  1. ไม่พบไฟล์ cache
  2. วันที่ปัจจุบันตรงกับ 1, 2, 15, 16, 17, 31 (±1 วันหวยออก) และ cache เก่า (timestamp เกิน 36 ชม. หรือวันล่าสุดใน cache ไม่ตรงวันหวยออก)
- หลังอัปเดต cache จะโหลดข้อมูลใหม่มาแสดงผลทันที
- **Backend** ไม่มี logic วิเคราะห์/เลขเด่น/แนวโน้ม/สถิติใด ๆ ทั้งสิ้น (เก็บ raw data อย่างเดียว)

## 📁 โครงสร้างไฟล์

```
lottery-thairath-analyzer/
├── index.html                # หน้าเว็บหลัก (Frontend + JS วิเคราะห์)
├── api/
│   ├── lottery_scraper.php   # PHP Scraper ดึงข้อมูลจากไทยรัฐ
│   ├── update_cache.php      # API สำหรับอัปเดต cache
│   └── lottery_cache.json    # ไฟล์ Cache (สร้างอัตโนมัติ)
└── README.md
```

## 🛠️ วิธีใช้งาน/ติดตั้ง

1. **Clone repo**
```bash
git clone https://github.com/goragodwiriya/lottery-thairath-analyzer.git
cd lottery-thairath-analyzer
```
2. **ตั้งค่าสิทธิ์การเขียนไฟล์**
```bash
chmod 755 api/
# (cache จะถูกสร้างอัตโนมัติเมื่อรัน update_cache.php)
```
3. **Deploy ตัวอย่างบน GitHub Pages**
- สามารถใช้ `index.html` เป็นหน้าเว็บหลักได้เลย (แนะนำให้ deploy เฉพาะ frontend)
- ถ้าต้องการ backend (PHP) ให้ deploy บน server ที่รองรับ PHP เท่านั้น

## ⚠️ ข้อควรระวัง/ข้อจำกัด
- ข้อมูลหวยทั้งหมดมาจากเว็บไทยรัฐ (Thairath) อาจมีการเปลี่ยนแปลงโครงสร้าง HTML ได้ในอนาคต
- ระบบนี้ใช้เพื่อการศึกษา/ตัวอย่างเท่านั้น ไม่ควรใช้เพื่อการพนันหรืออ้างอิงผลรางวัลจริง
- การ scrape ข้อมูลจากเว็บต้นทางควรใช้อย่างสุภาพ ไม่ควรเรียกซ้ำถี่เกินไป
- หากพบปัญหา cache ไม่อัปเดต ให้ตรวจสอบสิทธิ์การเขียนไฟล์ในโฟลเดอร์ `api/`

## 🤝 สนับสนุน/ติดต่อ
- ผู้แต่ง: Goragod Wiriya
- GitHub: [goragodwiriya/lottery-thairath-analyzer](https://github.com/goragodwiriya/lottery-thairath-analyzer)

---

> **หมายเหตุ:**
> - ตัวอย่างนี้เหมาะสำหรับการศึกษา/ทดลองเท่านั้น
> - ไม่สนับสนุนการพนันทุกรูปแบบ