# ครูนิวดอทคอม (KruNews.com)

![KruNews](https://img.shields.io/badge/KruNews-ข่าวการศึกษา-blue?style=for-the-badge)
![Version](https://img.shields.io/badge/Version-1.0.0-green?style=for-the-badge)
![License](https://img.shields.io/badge/License-MIT-yellow?style=for-the-badge)

## 📝 คำอธิบาย

เว็บไซต์ข่าวการศึกษาแบบ One-Page ที่ทันสมัย รวบรวมข่าวสารการศึกษา การเรียกบรรจุครูผู้ช่วย การสอบบรรจุพนักงานราชการ และข้อมูลสำคัญสำหรับครูทุกวัน ออกแบบด้วย Modern UI/UX และรองรับการใช้งานบนมือถือ

## ✨ คุณสมบัติเด่น

- 🎨 **Design ทันสมัย** - Modern UI/UX พร้อม Gradient และ Animation
- 📱 **Responsive Design** - รองรับทุกขนาดหน้าจอ (Desktop, Tablet, Mobile)
- 🖼️ **Hero Slideshow** - ระบบสไลด์โชว์อัตโนมัติพร้อม Navigation
- ⚡ **Performance** - โหลดเร็วด้วย CSS และ JavaScript ที่เขียนเอง
- 🎯 **SEO Optimized** - เพิ่มประสิทธิภาพสำหรับ Search Engine
- ♿ **Accessibility** - รองรับผู้พิการและ Screen Reader
- 🌈 **Thai Fonts** - ใช้ฟอนต์ Kanit และ Sarabun สำหรับภาษาไทย

## 🛠️ เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างเว็บไซต์
- **CSS3** - การจัดแต่งหน้าตา พร้อม CSS Variables และ Flexbox/Grid
- **Vanilla JavaScript** - ความโต้ตอบและ Slideshow
- **Font Awesome** - ไอคอนสวยงาม
- **Google Fonts** - ฟอนต์ภาษาไทย (Kanit, Sarabun)

## 📁 โครงสร้างไฟล์

```
kru-news/
├── index.html          # ไฟล์หลักของเว็บไซต์
├── img/               # โฟลเดอร์รูปภาพ
│   ├── 1.webp        # รูปภาพสไลด์ 1
│   ├── 2.webp        # รูปภาพสไลด์ 2
│   ├── 3.webp        # รูปภาพสไลด์ 3
│   ├── 4.webp        # รูปภาพสไลด์ 4
│   ├── 5.webp        # รูปภาพสไลด์ 5
│   └── 6.webp        # รูปภาพสไลด์ 6
└── README.md         # ไฟล์นี้
```

## 🚀 การติดตั้งและใช้งาน

### ข้อกำหนดระบบ
- Web Server (Apache, Nginx หรือ HTTP Server อื่นๆ)
- Browser ที่รองรับ HTML5 และ CSS3

### วิธีการติดตั้ง

1. **Download โปรเจ็กต์**

2. **อัปโหลดไฟล์ไปยัง Web Server**
   - อัปโหลดไฟล์ทั้งหมดไปยัง Web Server

3. **เปิดใช้งาน**
   - เข้าถึงเว็บไซต์ผ่าน Browser
   - ตัวอย่าง: `http://your-domain.com`

### การพัฒนาแบบ Local

```bash
# ใช้ Python HTTP Server
python -m http.server 8000

# หรือใช้ Node.js http-server
npx http-server

# หรือใช้ PHP Built-in Server
php -S localhost:8000
```

## 🎨 การปรับแต่ง

### เปลี่ยนสี Theme
แก้ไข CSS Variables ใน `:root` ของไฟล์ `index.html`:

```css
:root {
  --primary-color: #2563eb;    /* สีหลัก */
  --secondary-color: #dc2626;  /* สีรอง */
  --accent-color: #059669;     /* สีเน้น */
  /* ... */
}
```

### เพิ่มรูปภาพสไลด์
1. เพิ่มรูปภาพใน folder `img/`
2. แก้ไข HTML ในส่วน `.slideshow-container`
3. อัปเดต JavaScript Array `slideshow.slides`

### แก้ไขเนื้อหา
แก้ไขเนื้อหาในไฟล์ `index.html` ตามต้องการ

## 📱 Browser Support

- ✅ Chrome 60+
- ✅ Firefox 55+
- ✅ Safari 12+
- ✅ Edge 79+
- ✅ Mobile Browsers

## 🎯 SEO Features

- Meta Tags สำหรับ SEO
- Open Graph Tags
- Structured Data Ready
- Mobile-Friendly
- Fast Loading

## 📄 License

โปรเจ็กต์นี้อยู่ภายใต้ลิขสิทธิ์ MIT License - ดูรายละเอียดใน LICENSE file

## 👨‍💻 ผู้พัฒนา

**Goragod Wiriya**
- 🌐 Website: [goragod.com](https://goragod.com)
- 📧 Email: admin@goragod.com

## 🆘 การแก้ไขปัญหา

### ปัญหาที่พบบ่อย

**Q: รูปภาพไม่แสดง**
A: ตรวจสอบ path ของรูปภาพใน folder `img/` และแก้ไข src ใน HTML

**Q: ฟอนต์ไม่โหลด**
A: ตรวจสอบการเชื่อมต่ออินเทอร์เน็ตสำหรับ Google Fonts

**Q: Slideshow ไม่ทำงาน**
A: ตรวจสอบ JavaScript Console และแน่ใจว่ามีรูปภาพใน `.slide` elements

## 🔄 Version History

- **v1.0.0** (2025-01-07) - เวอร์ชันแรก
  - Hero Slideshow ระบบอัตโนมัติ
  - Responsive Design
  - SEO Optimized
  - Accessibility Support

---

## 🤖 AI Prompt สำหรับสร้างเว็บไซต์นี้

```
สร้างเว็บไซต์ข่าวการศึกษาแบบ One-Page สำหรับ "ครูนิวดอทคอม" ด้วยคุณสมบัติดังนี้:

**หัวข้อเว็บไซต์:** ครูนิวดอทคอม - ข่าวการศึกษา เรียกบรรจุครู สอบครูผู้ช่วย

**ความต้องการ:**
1. **Design ทันสมัย:** ใช้ Modern UI/UX, Gradient Colors, Card Design, และ Smooth Animations
2. **Responsive:** รองรับทุกขนาดหน้าจอ (Desktop, Tablet, Mobile)
3. **Hero Section:** สไลด์โชว์อัตโนมัติพร้อม Navigation Arrows และ Dots
4. **เนื้อหา:** รวมข่าวการศึกษา, เรียกบรรจุครู, สอบครูผู้ช่วย, พนักงานราชการ
5. **ฟอนต์ไทย:** ใช้ Google Fonts (Kanit, Sarabun)
6. **SEO:** Meta Tags, Open Graph, Keywords สำหรับข่าวการศึกษา
7. **Performance:** ใช้ Vanilla JavaScript, CSS Variables, และโหลดเร็ว
8. **Accessibility:** รองรับ Screen Reader และผู้พิการ

**สี Theme:**
- Primary: Blue (#2563eb)
- Secondary: Red (#dc2626)
- Accent: Green (#059669)
- พื้นหลัง: Light Gray และ White

**Sections ที่ต้องการ:**
- Header พร้อม Navigation
- Hero Slideshow (6 รูป)
- ข่าวการศึกษาล่าสุด
- เรียกบรรจุครู
- สอบครูผู้ช่วย
- Sidebar Widgets
- Footer

**Technical Requirements:**
- HTML5 Semantic
- CSS3 พร้อม Flexbox/Grid
- Vanilla JavaScript
- Font Awesome Icons
- No Framework Dependencies
- Fast Loading

ใช้ Folder Structure:
- index.html (ไฟล์หลัก)
- img/ (รูปภาพ 1.webp ถึง 6.webp)

ผู้แต่ง: Goragod Wiriya
AI: Claude

สร้างเป็นไฟล์ HTML เดียวพร้อม CSS และ JavaScript ภายใน รองรับภาษาไทยและทันสมัย
```

---

<div align="center">
<p>💙 สร้างด้วยความตั้งใจเพื่อชุมชนครู</p>
<p><strong>ครูนิวดอทคอม</strong> - ศูนย์รวมข่าวการศึกษาครบวงจร</p>
</div>
