# ราชินีในรัชกาลที่ ๙

เว็บไซต์สวยงามสำหรับน้อมรำลึกในพระมหากรุณาธิคุณของสมเด็จพระนางเจ้าสิริกิติ์

## สรุปโปรเจ็ค
โปรเจ็คนี้เป็นหน้า Landing Page ขนาดเล็ก (static) ใช้ HTML/CSS ในการแสดงผล โดยมีจุดเด่นเป็นภาพพระราชินีที่ถูกจัดให้เป็นวงกลมพร้อมเอฟเฟกต์ (glow, golden ring, hover effects) และภาพพื้นหลังแบบโมโนโครม พร้อมเอฟเฟกต์เล็กๆ เช่น particle sparkle, gradient overlay และการเคลื่อนไหวเล็กน้อยของเนื้อหา

## คุณสมบัติเด่น
- รูปภาพหลักเป็นวงกลม พร้อม glow และแหวนสีทองที่หมุนรอบ
- เอฟเฟกต์พื้นหลัง (sparkles) เพิ่มความละมุนและยกบรรยากาศ
- หัวข้อหลัก (H1) ใช้ gradient สีทองและ animation
- ปุ่มเข้าสู่เว็บไซต์มี shimmer/hover effect
- รองรับ responsive เบื้องต้นสำหรับมือถือและแท็บเล็ต
- ไม่มี dependency ภายนอก (static HTML/CSS)

## โครงสร้างไฟล์
- `index.html` — หน้าเริ่มต้นของเว็บไซต์
- `style.css` — ไฟล์สไตล์หลัก (ปรับปรุงให้มีเอฟเฟกต์และ responsive)
- `images/` — โฟลเดอร์เก็บรูปภาพ (เช่น `queen_sirikit.webp`, `bg_monochrome.jpg`)

## วิธีดูตัวอย่าง (Preview)
วิธีที่ง่ายที่สุดคือเปิด `index.html` ในเบราว์เซอร์โดยตรง (ดับเบิลคลิกหรือเลือก Open File) แต่บางฟีเจอร์ (เช่นการโหลดฟอนต์ผ่านเว็บ) อาจทำงานได้ดีกว่าเมื่อเสิร์ฟผ่าน HTTP server เล็กๆ

ตัวอย่างการรัน HTTP server แบบง่าย (Python 3):

```bash
cd /mnt/Server/htdocs/intro
python3 -m http.server 8000
# จากนั้นเปิด: http://localhost:8000
```

หรือถ้าใช้ Node.js / serve (ต้องติดตั้ง `serve`):

```bash
npx serve .
```

## ปรับแต่ง (Customization)
- เปลี่ยนรูป: แทนที่ไฟล์ใน `images/` (เช่น `queen_sirikit.webp`) แล้วตรวจสอบ `index.html` ให้ชี้ไปยังไฟล์ใหม่
- ปรับขนาด/เอฟเฟกต์: แก้ไข `style.css` โดยตรง (คลาสสำคัญ: `.emblem img`, `.emblem::before`, `body::before`, `h1`, `button.enter`)
- เปลี่ยนพื้นหลัง: แก้ `background` ใน `.intro` (ไฟล์ `bg_monochrome.jpg` หรือ URL ใหม่)
- ฟอนต์: ปัจจุบันใช้ Google Font `Sarabun` ใน `<head>` ของ `index.html` — หากต้องการเปลี่ยน ให้แก้ `<link>` ไปยังฟอนต์ที่ต้องการ

## ข้อมูลเพิ่มเติม / แหล่งที่มา
- ฟอนต์: Google Fonts — Sarabun
- รูปภาพ: โปรดตรวจสอบสิทธิ์การใช้งานของรูปภาพที่อยู่ใน `images/` ก่อนเผยแพร่สาธารณะ

## ผู้พัฒนา
- Goragod Wiriya