Luxury Hotel — Static demo site

A small single-page static demo for a hotel website with a modern UI, gallery slideshow, room listings, and a basic booking flow. Built with plain HTML, CSS and vanilla JavaScript (IndexedDB used for local demo data).

Author: Goragod Wiriya
Date: 29 สิงหาคม 2568

Features
- Modern landing page (hero, features, offers, testimonials)
- Rooms gallery with thumbnail grid and large slideshow
- Full-screen gallery modal slideshow (keyboard nav, autoplay, pause on hover)
- Room details modal and booking flow (client-side demo)
- IndexedDB-based seed data for rooms, bookings and gallery

Quick start (local)
1. Requirements: Python 3 (or any static server)
2. From project root, run:

```bash
python3 -m http.server 8000
```

3. Open http://127.0.0.1:8000 in your browser.

Project structure (important files)
- `index.html` — single-page markup and modal containers
- `styles.css` — all styles (theme, slideshow, responsive rules)
- `script.js` — app logic (DatabaseManager, HotelBookingApp, gallery & booking functions)

Developer notes
- On first load the app seeds demo data into IndexedDB. If you clear site storage the app will re-seed when you open the Gallery page.
- Slideshow state is managed inside `HotelBookingApp` (methods: `createMainGallerySlideshow`, `showMainSlide`, `startMainGalleryAutoplay`, `stopMainGalleryAutoplay`, `openGallerySlideshow`).
- Keep edits small and run a browser check after changes. Use browser DevTools console for debug logs (the app prints diagnostic messages such as `showPage called:` and `loadGallery:`).

Common commands
- Start local server: `python3 -m http.server 8000`
- Lint/check JS: open `script.js` in VS Code or run a local linter you prefer

Ideas for next improvements
- Swipe support for mobile slideshow
- Focus trap and ARIA attributes for accessibility
- Lazy-loading large images or progressive placeholders
- Small unit tests for utility functions

License & contact
- Author: Goragod Wiriya
- This demo code is permissive for learning and prototyping. For commercial use, please add a LICENSE file and attribution.

Prompt
```
เว็บไซต์จองห้องพัก มีหน้าเว็บแสดงรายละเอียดของห้องพัก มีแกลเลอรี (Gallery) มีระบบจองห้องพัก มีระบบบริหารจัดการการจอง การชำระเงิน และการแจ้งเตือน
เทคโนโลยีเว็บไซต์ HTML, CSS, Vanilla JavaScript (ไม่ใช้ Framework) ฐานข้อมูล IndexedDB ใช้รูปภาพออนไลน์
ข้อมูลตัวอย่างจัดเก็บใน IndexedDB ใช้งานครบทุกส่วน
ใช้ Icon Font และ Google Font (รองรับภาษาไทย สวยงาม)

คุณสมบัติ
- หน้าเว็บเป็นแบบ SPA (Single Page Application)
- โหลดข้อมูลจาก Template
- รองรับการทำ SEO แบบเต็มรูปแบบ
```
