<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Debug Autoloader\n";
echo "Current dir: ".__DIR__."\n";
echo "API dir: ".__DIR__."/api\n";
echo "Src dir: ".__DIR__."/api/src\n";

$autoloaderPath = __DIR__."/api/src/Core/Autoloader.php";
echo "Autoloader path: ".$autoloaderPath."\n";
echo "File exists: ".(file_exists($autoloaderPath) ? 'Yes' : 'No')."\n";

if (file_exists($autoloaderPath)) {
    require_once $autoloaderPath;
    echo "Autoloader loaded\n";

    $autoloader = new \App\Core\Autoloader();
    $autoloader->addNamespace('App', __DIR__."/api/src");
    $autoloader->register();
    echo "Autoloader registered\n";

    if (class_exists('App\Core\Router')) {
        echo "Router class found!\n";
    } else {
        echo "Router class NOT found\n";
    }
}
