<?php
/**
 * Router for PHP Built-in Server
 * This file handles routing for development server
 */

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Handle API routes
if (strpos($uri, '/api/') === 0) {
    $_SERVER['REQUEST_URI'] = substr($uri, 4); // Remove /api prefix
    require 'api/public/index.php';
    return true;
}

// Handle admin routes
if (strpos($uri, '/admin/') === 0) {
    $_SERVER['REQUEST_URI'] = substr($uri, 6); // Remove /admin prefix
    require 'api/public/admin.php';
    return true;
}

// Handle static files
if (file_exists(__DIR__ . $uri)) {
    return false; // Let PHP serve the file
}

// Fallback to index.html for frontend routes
if (file_exists(__DIR__ . '/index.html')) {
    require 'index.html';
    return true;
}

// 404 for everything else
http_response_code(404);
echo "404 Not Found";
return true;