# ฟอร์มตั้งค่าร้านค้าออนไลน์

## คุณสมบัติหลัก

### 1. การตั้งค่าทั่วไป (General Settings)
- **ชื่อร้านค้า**: กำหนดชื่อร้านค้าที่จะแสดงในหน้าเว็บ
- **คำอธิบายร้านค้า**: คำอธิบายสั้นๆ เกี่ยวกับร้านค้า
- **โลโก้ร้านค้า**: อัพโลดโลโก้ของร้านค้า
- **ข้อมูลติดต่อ**: เบอร์โทร, อีเมล, ที่อยู่
- **โซเชียลมีเดีย**: Facebook, Line ID

### 2. การตั้งค่าการชำระเงิน (Payment Settings)
- **PromptPay**: หมายเลข PromptPay และชื่อบัญชี
- **บัญชีธนาคาร**: เพิ่ม/ลบบัญชีธนาคารหลายบัญชี
- **COD**: เปิด/ปิดการชำระเงินปลายทาง

### 3. การตั้งค่าการจัดส่ง (Shipping Settings)
- **ค่าจัดส่งทั่วไป**: กำหนดค่าจัดส่งพื้นฐาน
- **จัดส่งฟรี**: ยอดขั้นต่ำสำหรับจัดส่งฟรี
- **เขตพื้นที่จัดส่ง**: กำหนดเขตและค่าจัดส่งแต่ละเขต
- **ระยะเวลาจัดส่ง**: กำหนดระยะเวลาจัดส่งขั้นต่ำและสูงสุด

### 4. การตั้งค่าสินค้า (Products Settings)
- **หมวดหมู่สินค้า**: เพิ่ม/ลบ/แก้ไขหมวดหมู่สินค้า
- **ไซส์สินค้า**: กำหนดไซส์ที่มีให้เลือก
- **สีสินค้า**: กำหนดสีและ Hex Code ของสีต่างๆ

### 5. การตั้งค่าการแจ้งเตือน (Notifications Settings)
- **อีเมลผู้ดูแล**: อีเมลสำหรับรับการแจ้งเตือน
- **การแจ้งเตือนออเดอร์**: แจ้งเตือนออเดอร์ใหม่, การชำระเงิน
- **การแจ้งเตือนลูกค้า**: อีเมลยืนยันออเดอร์, การจัดส่ง
- **Line Notify**: Token สำหรับแจ้งเตือนผ่าน Line

### 6. การตั้งค่าระบบ (System Settings)
- **ภาษาและสกุลเงิน**: กำหนดภาษาและสกุลเงินของระบบ
- **โซนเวลา**: กำหนดโซนเวลาสำหรับระบบ
- **API Configuration**: Base URL ของ API
- **ความปลอดภัย**: JWT Secret Key, Session Timeout
- **โหมดพิเศษ**: Debug Mode, Maintenance Mode

## การใช้งาน

### การเปิดฟอร์มตั้งค่า
1. คลิกไอคอนเฟือง (⚙️) ที่มุมขวาบนของหน้าเว็บ
2. ฟอร์มตั้งค่าจะเปิดขึ้นมาในรูปแบบ Modal

### การนำทางระหว่างแท็บ
- ใช้แท็บด้านบนเพื่อสลับระหว่างหมวดการตั้งค่าต่างๆ
- แต่ละแท็บจะมีไอคอนและชื่อที่สื่อความหมาย

### การบันทึกการตั้งค่า
1. กรอกข้อมูลในแต่ละแท็บตามต้องการ
2. คลิกปุ่ม "บันทึกการตั้งค่า" เมื่อเสร็จสิ้น
3. ระบบจะบันทึกทั้งใน LocalStorage และ API (หากมี)

### การ Export/Import การตั้งค่า
- **Export**: คลิกปุ่ม "Export" เพื่อดาวน์โลดไฟล์การตั้งค่า (.json)
- **Import**: คลิกปุ่ม "Import" เพื่อนำเข้าการตั้งค่าจากไฟล์
- **รีเซ็ต**: คลิกปุ่ม "รีเซ็ต" เพื่อกลับไปใช้การตั้งค่าเริ่มต้น

## ฟีเจอร์เพิ่มเติม

### การอัพเดตแบบเรียลไทม์
- เมื่อบันทึกการตั้งค่า หน้าเว็บจะอัพเดตทันที
- ชื่อร้าน, ข้อมูลติดต่อ, หมวดหมู่สินค้าจะเปลี่ยนแปลงทันที

### การจัดการหมวดหมู่และตัวเลือกสินค้า
- เพิ่ม/ลบหมวดหมู่สินค้าได้แบบไดนามิก
- เพิ่ม/ลบไซส์และสีสินค้าตามต้องการ
- ระบบจะอัพเดต dropdown filter ในหน้าสินค้าทันที

### ความปลอดภัย
- JWT Secret Key สามารถสร้างใหม่ได้อัตโนมัติ
- ข้อมูลที่สำคัญจะถูกเข้ารหัสก่อนส่งไป API
- มีการตรวจสอบสิทธิ์ Admin ก่อนการแก้ไข

## การเชื่อมต่อกับ API

### Endpoints ที่เกี่ยวข้อง
- `GET /api/admin/settings` - ดึงการตั้งค่าปัจจุบัน
- `POST /api/admin/settings` - บันทึกการตั้งค่าใหม่
- `POST /api/admin/settings/reset` - รีเซ็ตการตั้งค่า
- `GET /api/admin/settings/export` - ส่งออกการตั้งค่า
- `POST /api/admin/settings/import` - นำเข้าการตั้งค่า

### การจัดเก็บข้อมูล
- **Frontend**: ใช้ LocalStorage สำหรับจัดเก็บชั่วคราว
- **Backend**: บันทึกในไฟล์ JSON (/api/storage/settings.json)
- **Database**: สามารถขยายให้เก็บในฐานข้อมูลได้ในอนาคต

## การปรับแต่ง

### การเพิ่มการตั้งค่าใหม่
1. เพิ่มฟิลด์ใหม่ในฟอร์ม HTML
2. อัพเดตฟังก์ชัน `collectSettings()` ใน JavaScript
3. เพิ่มการ validation ใน `SettingsController.php`
4. อัพเดตฟังก์ชัน `applySettings()` สำหรับการนำไปใช้

### การปรับแต่ง UI
- CSS classes สำหรับการตั้งค่าขึ้นต้นด้วย `.settings-`
- สามารถปรับสีธีม, ขนาด, และเอฟเฟคได้ใน `style.css`
- Responsive design รองรับทุกขนาดหน้าจอ

## การแก้ไขปัญหา

### การตั้งค่าไม่บันทึก
1. ตรวจสอบ Console ใน Developer Tools
2. ตรวจสอบการเชื่อมต่อ API
3. ตรวจสอบสิทธิ์ Admin Token

### การตั้งค่าไม่แสดงผล
1. ตรวจสอบ LocalStorage ใน Developer Tools
2. ลองรีเฟรชหน้าเว็บ
3. ตรวจสอบ JavaScript Errors

### การ Import/Export ไม่ทำงาน
1. ตรวจสอบรูปแบบไฟล์ JSON
2. ตรวจสอบสิทธิ์การเข้าถึงไฟล์
3. ลองใช้ฟีเจอร์ LocalStorage แทน API

## ข้อควรระวัง

1. **สำรองข้อมูล**: ควร Export การตั้งค่าก่อนทำการเปลี่ยนแปลงครั้งใหญ่
2. **การทดสอบ**: ทดสอบการตั้งค่าใหม่ก่อนนำไปใช้งานจริง
3. **ความปลอดภัย**: อย่าแชร์ JWT Secret Key หรือข้อมูลที่สำคัญ
4. **Performance**: หลีกเลี่ยงการตั้งค่าที่ซับซ้อนเกินไปซึ่งอาจส่งผลต่อประสิทธิภาพ
