# Dynamic Path Configuration Summary

## 🔧 ปัญหาที่แก้ไข
Admin panel มี hard-coded paths ที่ไม่รองรับการติดตั้งใน subfolder หรือการเปลี่ยนชื่อโฟลเดอร์

## ✅ การแก้ไข

### 1. Dynamic Path Detection
เพิ่ม path detection ที่อัตโนมัติ detect base path จาก URL ปัจจุบัน:

```javascript
const BASE_PATH = (() => {
  const path = window.location.pathname;
  const pathParts = path.split('/');

  // Find admin folder index
  const adminIndex = pathParts.indexOf('admin');
  if (adminIndex > 0) {
    // Return base path up to admin folder (excluding admin)
    return pathParts.slice(0, adminIndex).join('/');
  }

  // Default to root if admin not found in path
  return '';
})();
```

### 2. Dynamic URLs
```javascript
const ADMIN_BASE_PATH = BASE_PATH + '/admin';
const API_BASE = BASE_PATH + '/admin/api';
const AUTH_API = BASE_PATH + '/api';
```

### 3. ไฟล์ที่แก้ไข

#### `/admin/assets/js/dashboard.js`
- เพิ่ม dynamic path detection
- แก้ไข API URLs
- แก้ไข redirect URLs ใน checkAuth() และ logout()

#### `/admin/assets/js/login.js`
- เพิ่ม dynamic path detection
- แก้ไข API URLs
- แก้ไข redirect URLs หลัง login สำเร็จ
- เพิ่มฟังก์ชัน goBackToStore()

#### `/admin/login.html`
- เพิ่ม dynamic path detection ใน inline script
- แก้ไข redirect URLs
- แก้ไข "Back to Store" link ให้เป็น dynamic

## 🎯 ผลลัพธ์

### รองรับการติดตั้งใน:
- `/store/admin/` (subfolder)
- `/shop/admin/`
- `/admin/` (root level)
- `/mysite/v2/admin/` (nested folders)
- `/任何名称/admin/` (ชื่อโฟลเดอร์ภาษาอื่น)

### URL Examples:
```
http://localhost/store/admin/ → BASE_PATH: /store
http://localhost/shop/admin/  → BASE_PATH: /shop
http://localhost/admin/       → BASE_PATH: ''
http://domain.com/admin/      → BASE_PATH: ''
```

### API Endpoints จะปรับตาม:
```
/store/api/auth/login
/store/admin/api/dashboard
/shop/api/auth/me
/shop/admin/api/orders
```

## 🧪 การทดสอบ
สร้างไฟล์ `/admin/path-test.html` สำหรับทดสอบ path detection

## 📝 หมายเหตุ
- รองรับการเปลี่ยนชื่อโฟลเดอร์โดยไม่ต้องแก้ไขโค้ด
- ใช้งานได้ทั้ง development และ production
- ไม่มี hard-coded paths อีกต่อไป
