# SVG & CSS Effects Generator

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![HTML5](https://img.shields.io/badge/HTML5-E34F26?style=flat&logo=html5&logoColor=white)](https://developer.mozilla.org/en-US/docs/Web/HTML)
[![CSS3](https://img.shields.io/badge/CSS3-1572B6?style=flat&logo=css3&logoColor=white)](https://developer.mozilla.org/en-US/docs/Web/CSS)
[![JavaScript](https://img.shields.io/badge/JavaScript-F7DF1E?style=flat&logo=javascript&logoColor=black)](https://developer.mozilla.org/en-US/docs/Web/JavaScript)

เครื่องมือสร้าง SVG และ CSS Effects แบบอินเตอร์แอคทีฟที่ช่วยให้คุณสามารถสร้างกราฟิก SVG และเอฟเฟกต์ CSS ต่างๆ ได้ง่ายๆ ด้วยการปรับค่าแบบ real-time พร้อมด้วยตัวอย่างและโค้ดที่สามารถคัดลอกไปใช้ได้ทันที

## 🌟 Features

### 📐 SVG Generator
- **รูปทรงหลากหลาย**: Circle, Rectangle, Polygon, Star, Ellipse, Path
- **ปรับแต่งพารามิเตอร์**: รัศมี, ขนาด, จำนวนด้าน, มุมหมุน
- **ควบคุมสี**: Fill color, stroke color, stroke width
- **แสดงผลแบบ real-time**: ดูการเปลี่ยนแปลงได้ทันที
- **โค้ด SVG พร้อมใช้**: คัดลอกโค้ดได้ทันที

### 🎨 Box Shadow Generator
- **ควบคุมทุกมิติ**: Horizontal/Vertical offset, blur, spread
- **ปรับความโปร่งแสง**: Opacity control
- **เลือกประเภทเงา**: Regular หรือ inset shadow
- **Color picker**: เลือกสีเงาได้อย่างแม่นยำ
- **พรีวิวสด**: ดูผลลัพธ์บน element จริง

### ✨ Text Shadow Generator
- **ปรับแต่งข้อความ**: เนื้อหา, ขนาด, น้ำหนักฟอนต์
- **ควบคุมเงา**: Offset, blur, color, opacity
- **ตัวอย่างขนาดใหญ่**: ดูผลลัพธ์อย่างชัดเจน
- **CSS สมบูรณ์**: ได้โค้ด CSS พร้อมใช้

### 🌈 Gradient Generator
- **2 ประเภท**: Linear และ Radial gradient
- **หลาย Color Stops**: เพิ่ม/ลบจุดสีได้ไม่จำกัด
- **ควบคุมตำแหน่ง**: กำหนดตำแหน่งของแต่ละสี
- **Angle control**: ปรับมุมของ linear gradient
- **Live preview**: ดูการเปลี่ยนแปลงแบบทันที

## 🚀 Quick Start

### วิธีใช้งาน Online
เพียงเปิดไฟล์ `index.html` ในเบราว์เซอร์ของคุณ:

```bash
# Clone repository
git clone https://github.com/yourusername/svg-css-effects-generator.git

# เข้าไปในโฟลเดอร์
cd svg-css-effects-generator

# เปิดไฟล์ในเบราว์เซอร์
open index.html
# หรือใช้ live server
npx live-server
```

## 📄 License
โปรเจ็คนี้ใช้สัญญาอนุญาต MIT License - ดูรายละเอียดได้ที่ LICENSE file

## 👨‍💻 Author
Goragod Wiriya

## 🙏 Acknowledgments
- ขอบคุณผู้ที่สนับสนุนและใช้งานเครื่องมือนี้
- ขอบคุณ community ที่ให้คำแนะนำและ feedback



Made with ❤️ for developers and designers