# คู่มือการใช้งาน Documentation System

## ภาพรวม

ระบบเอกสารนี้เป็นระบบแสดงผลไฟล์ Markdown แบบเรียลไทม์ที่ออกแบบมาเพื่อแสดงเอกสารของ Kotchasan Framework

## คุณสมบัติหลัก

### 🌐 หลายภาษา
- รองรับภาษาไทยและอังกฤษ
- เปลี่ยนภาษาได้แบบเรียลไทม์
- ไฟล์เอกสารแยกตามภาษา

### 🎨 ธีม
- โหมดสว่าง (Light Mode)
- โหมดมืด (Dark Mode)
- เปลี่ยนธีมได้ทันที

### 📱 Responsive Design
- รองรับทุกขนาดหน้าจอ
- Mobile-first design
- Touch-friendly interface

## การใช้งานพื้นฐาน

### 1. เปิดระบบเอกสาร

```bash
# เปิดไฟล์ index.html ในเบราว์เซอร์
open index.html

# หรือใช้ local server
python3 -m http.server 8000
# เปิด http://localhost:8000
```

### 2. การนำทาง

#### เมนูด้านซ้าย
- แสดงรายการเอกสารทั้งหมด
- คลิกเพื่อเปลี่ยนเอกสาร
- แสดงสถานะเอกสารที่เลือก

#### การเปลี่ยนภาษา
- คลิกปุ่ม 🌐 TH/EN
- ระบบจะโหลดเอกสารภาษาที่เลือก
- รองรับการเปลี่ยนภาษาแบบเรียลไทม์

#### การเปลี่ยนธีม
- คลิกปุ่ม 🌙 Dark/☀️ Light
- เปลี่ยนสีพื้นหลังและข้อความ
- บันทึกการตั้งค่าใน localStorage

### 3. การอ่านเอกสาร

#### Markdown Support
- รองรับ Markdown syntax ครบถ้วน
- Code highlighting สำหรับ PHP, JavaScript, CSS
- ตาราง, รายการ, ลิงก์

#### Code Blocks
```markdown
```php
<?php
echo "Hello World";
```
```

#### Tables
```markdown
| Column 1 | Column 2 |
|----------|----------|
| Data 1   | Data 2   |
```

## การจัดการเอกสาร

### โครงสร้างไฟล์

```
docs/
├── th/                    # เอกสารภาษาไทย
│   ├── index.md          # หน้าแรก
│   ├── installation.md   # คู่มือติดตั้ง
│   ├── getting-started.md # เริ่มต้นใช้งาน
│   ├── api-reference.md   # API Reference
│   └── usage-guide.md     # คู่มือการใช้งาน
└── en/                    # เอกสารภาษาอังกฤษ
    ├── index.md
    ├── installation.md
    ├── getting-started.md
    ├── api-reference.md
    └── usage-guide.md
```

### การเพิ่มเอกสารใหม่

#### 1. สร้างไฟล์ Markdown

```bash
# สร้างไฟล์ใหม่
touch docs/th/new-document.md
touch docs/en/new-document.md
```

#### 2. เขียนเนื้อหา

```markdown
# ชื่อเอกสาร

## บทนำ
เนื้อหาของเอกสาร

## เนื้อหาหลัก
- รายการ 1
- รายการ 2

## สรุป
สรุปเนื้อหา
```

#### 3. ระบบจะโหลดอัตโนมัติ

ไฟล์จะปรากฏในเมนูด้านซ้ายทันที

### การตั้งชื่อไฟล์

#### กฎการตั้งชื่อ
- ใช้ภาษาอังกฤษเท่านั้น
- ใช้เครื่องหมาย `-` แทนช่องว่าง
- ใช้ตัวพิมพ์เล็กทั้งหมด
- หลีกเลี่ยงอักขระพิเศษ

#### ตัวอย่างชื่อไฟล์
```
✅ ถูกต้อง:
- getting-started.md
- api-reference.md
- troubleshooting.md

❌ ผิด:
- Getting Started.md
- api_reference.md
- การใช้งาน.md
```

## การปรับแต่ง

### การเปลี่ยนสี

#### แก้ไข CSS Variables

```css
:root {
  --bg-primary: #ffffff;        /* สีพื้นหลังหลัก */
  --bg-secondary: #f8f9fa;     /* สีพื้นหลังรอง */
  --text-primary: #212529;      /* สีข้อความหลัก */
  --accent: #0d6efd;           /* สีเน้น */
}
```

#### Dark Mode
```css
[data-theme="dark"] {
  --bg-primary: #1a1d23;
  --bg-secondary: #22252b;
  --text-primary: #e9ecef;
  --accent: #4dabf7;
}
```

### การเพิ่มฟีเจอร์

#### เพิ่มปุ่มใหม่

```html
<button class="btn" id="newFeatureBtn">🆕 ฟีเจอร์ใหม่</button>
```

```javascript
document.getElementById('newFeatureBtn').addEventListener('click', () => {
    // ฟังก์ชันใหม่
});
```

#### เพิ่มเมนู

```javascript
// เพิ่มเมนูใหม่
function addCustomMenu() {
    const menu = document.getElementById('fileTree');
    const newItem = document.createElement('div');
    newItem.className = 'file-item';
    newItem.textContent = 'เมนูใหม่';
    newItem.onclick = () => loadCustomContent();
    menu.appendChild(newItem);
}
```

## การแก้ไขปัญหา

### ปัญหาที่พบบ่อย

#### 1. ไฟล์ไม่โหลด

**สาเหตุ:**
- ชื่อไฟล์ผิด
- ไฟล์ไม่อยู่ในตำแหน่งที่ถูกต้อง
- สิทธิ์ไฟล์ไม่ถูกต้อง

**วิธีแก้:**
```bash
# ตรวจสอบชื่อไฟล์
ls -la docs/th/

# ตรวจสอบสิทธิ์
chmod 644 docs/th/*.md

# ตรวจสอบโครงสร้าง
tree docs/
```

#### 2. ธีมไม่เปลี่ยน

**สาเหตุ:**
- JavaScript error
- CSS ไม่โหลด
- Cache เบราว์เซอร์

**วิธีแก้:**
```javascript
// ตรวจสอบ console
console.log('Theme:', currentTheme);

// ล้าง cache
localStorage.clear();
location.reload();
```

#### 3. ภาษาไม่เปลี่ยน

**สาเหตุ:**
- ไฟล์ .md ไม่มีในภาษาที่เลือก
- ชื่อไฟล์ไม่ตรงกัน
- JavaScript error

**วิธีแก้:**
```javascript
// ตรวจสอบไฟล์ที่มี
console.log('Available docs:', Object.keys(docs));

// ตรวจสอบภาษา
console.log('Current lang:', currentLang);
```

### การ Debug

#### เปิด Developer Tools

```javascript
// ตรวจสอบสถานะ
console.log('Current language:', currentLang);
console.log('Current theme:', currentTheme);
console.log('Available documents:', Object.keys(docs));
console.log('Current document:', currentDoc);
```

#### ตรวจสอบ Network

1. เปิด Developer Tools (F12)
2. ไปที่แท็บ Network
3. ดูการโหลดไฟล์ .md
4. ตรวจสอบ HTTP status codes

## การ Deploy

### 1. เตรียมไฟล์

```bash
# สร้างไฟล์สำหรับ production
cp -r docs/ production/
cp index.html production/
cp README.md production/
```

### 2. อัปโหลด

```bash
# ใช้ rsync
rsync -avz production/ user@server:/var/www/docs/

# ใช้ scp
scp -r production/* user@server:/var/www/docs/
```

### 3. ตั้งค่า Web Server

#### Apache
```apache
<VirtualHost *:80>
    ServerName docs.yourdomain.com
    DocumentRoot /var/www/docs

    <Directory "/var/www/docs">
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx
```nginx
server {
    listen 80;
    server_name docs.yourdomain.com;
    root /var/www/docs;
    index index.html;

    location / {
        try_files $uri $uri/ /index.html;
    }

    location ~ \.md$ {
        add_header Content-Type text/plain;
    }
}
```

## การบำรุงรักษา

### การอัปเดตเอกสาร

```bash
# อัปเดตเอกสาร
git pull origin main

# ตรวจสอบการเปลี่ยนแปลง
git diff HEAD~1

# ทดสอบการทำงาน
python3 -m http.server 8000
```

### การสำรองข้อมูล

```bash
# สำรองไฟล์
tar -czf docs-backup-$(date +%Y%m%d).tar.gz docs/

# สำรองฐานข้อมูล (ถ้ามี)
mysqldump -u user -p database > backup.sql
```

### การติดตามการใช้งาน

```javascript
// เพิ่ม Google Analytics
gtag('config', 'GA_MEASUREMENT_ID');

// ติดตามการเปลี่ยนภาษา
function trackLanguageChange(lang) {
    gtag('event', 'language_change', {
        'language': lang
    });
}

// ติดตามการเปลี่ยนธีม
function trackThemeChange(theme) {
    gtag('event', 'theme_change', {
        'theme': theme
    });
}
```

## การพัฒนาต่อ

### การเพิ่มฟีเจอร์ใหม่

#### 1. Search Functionality

```javascript
// เพิ่มฟังก์ชันค้นหา
function addSearch() {
    const searchInput = document.createElement('input');
    searchInput.type = 'text';
    searchInput.placeholder = 'ค้นหาเอกสาร...';
    searchInput.onkeyup = (e) => searchDocuments(e.target.value);
    document.querySelector('.header-controls').appendChild(searchInput);
}

function searchDocuments(query) {
    const results = Object.keys(docs).filter(doc =>
        doc.toLowerCase().includes(query.toLowerCase())
    );
    // แสดงผลการค้นหา
}
```

#### 2. Print Functionality

```javascript
// เพิ่มฟังก์ชันพิมพ์
function addPrintButton() {
    const printBtn = document.createElement('button');
    printBtn.className = 'btn';
    printBtn.innerHTML = '🖨️ พิมพ์';
    printBtn.onclick = () => window.print();
    document.querySelector('.header-controls').appendChild(printBtn);
}
```

#### 3. Export Functionality

```javascript
// เพิ่มฟังก์ชันส่งออก
function addExportButton() {
    const exportBtn = document.createElement('button');
    exportBtn.className = 'btn';
    exportBtn.innerHTML = '📄 ส่งออก';
    exportBtn.onclick = () => exportDocument();
    document.querySelector('.header-controls').appendChild(exportBtn);
}

function exportDocument() {
    const content = document.getElementById('content').innerHTML;
    const blob = new Blob([content], { type: 'text/html' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = `${currentDoc}.html`;
    a.click();
}
```

---

**หมายเหตุ**: คู่มือนี้ครอบคลุมการใช้งานระบบเอกสาร สำหรับข้อมูลเพิ่มเติมโปรดดูที่ [API Reference](api-reference.md)

