<?php
// php/api_handler.php

/**
 * Fetches data from an external API (simulated).
 *
 * @param string $endpoint The specific API endpoint or resource to query.
 * @param array $params Additional parameters for the API request.
 * @return array|null The API response data as an associative array, or null on error.
 */
function fetchFromApi(string $endpoint, array $params = []): ?array
{
    // Simulate API interaction
    error_log("API Handler: Called for endpoint '$endpoint' with params: " . json_encode($params));

    // Simulate network delay
    // usleep(rand(200000, 800000)); // 200ms to 800ms

    if ($endpoint === 'monthly_revenue') {
        // Simulate data for a chart (e.g., monthly revenue)
        $months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
        $currentMonthIndex = (int)date('m') - 1; // 0-indexed current month
        $displayMonths = array_slice($months, 0, $currentMonthIndex + 1);

        return [
            'chartTitle' => 'Monthly Revenue ' . date('Y') . ' (Simulated API)',
            'labels' => $displayMonths,
            'datasets' => [
                [
                    'label' => 'Revenue (USD)',
                    'data' => array_map(function() { return rand(1000, 15000); }, $displayMonths),
                    'backgroundColor' => 'rgba(54, 162, 235, 0.6)',
                    'borderColor' => 'rgba(54, 162, 235, 1)',
                    'borderWidth' => 1,
                    'tension' => 0.1 // For line charts
                ],
                [
                    'label' => 'Expenses (USD)',
                    'data' => array_map(function() { return rand(500, 7000); }, $displayMonths),
                    'backgroundColor' => 'rgba(255, 99, 132, 0.6)',
                    'borderColor' => 'rgba(255, 99, 132, 1)',
                    'borderWidth' => 1,
                    'tension' => 0.1 // For line charts
                ]
            ]
        ];
    } elseif ($endpoint === 'user_activity') {
        return [
            'chartTitle' => 'User Activity (Simulated API)',
            'labels' => ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            'datasets' => [
                [
                    'label' => 'Page Views',
                    'data' => [rand(100,500),rand(100,500),rand(100,500),rand(100,500),rand(100,500),rand(100,500),rand(100,500)],
                    'backgroundColor' => 'rgba(75, 192, 192, 0.6)',
                ]
            ]
        ];
    }

    error_log("API Handler: Unknown endpoint '$endpoint'");
    return ['error' => "Unknown API endpoint: $endpoint"];
}

// Example of how you might call this in a real scenario (not used by data_provider.php directly like this)
/*
if (basename(__FILE__) == basename($_SERVER["SCRIPT_FILENAME"])) {
    header('Content-Type: application/json');
    $testEndpoint = $_GET['ep'] ?? 'monthly_revenue';
    $simulatedData = fetchFromApi($testEndpoint, $_GET);
    if (isset($simulatedData['error'])) {
        http_response_code(404);
    }
    echo json_encode($simulatedData);
}
*/
?>
