# Admin Dashboard

A fully-featured admin dashboard built with vanilla HTML, CSS, and JavaScript, designed to work with REST API backends.

## Features

### 🔐 Authentication
- Login/Logout functionality
- Session management with localStorage
- Protected routes
- Demo credentials provided

### 📊 Dashboard
- Overview statistics cards
- Interactive charts (revenue, user growth, sales analytics)
- Recent activity timeline
- Responsive design

### 👥 User Management
- User listing with search and filters
- Add/Edit/Delete users
- Role-based access display
- Pagination
- Export to CSV

### 📦 Product Management
- Product grid view
- Add new products
- Product categories
- Stock management

### 📋 Order Management
- Order listing
- Status tracking
- Order details

### 📈 Analytics
- Multiple chart types (line, bar, pie, doughnut)
- Sales analytics
- Category distribution
- Traffic sources

### ⚙️ Settings
- Profile management
- Theme toggle (Light/Dark mode)
- Notification preferences

### 🎨 UI Features
- Modern, clean design
- Fully responsive (mobile, tablet, desktop)
- Dark/Light theme support
- Toast notifications
- Modal dialogs
- Loading states
- Smooth animations

## Demo Credentials

**Email:** admin@example.com  
**Password:** admin123

## Project Structure

```
/
├── index.html              # Main dashboard page
├── login.html              # Login page
├── css/
│   ├── style.css          # Base styles and components
│   ├── dashboard.css      # Dashboard-specific styles
│   └── responsive.css     # Responsive breakpoints
├── js/
│   ├── app.js            # Main application logic
│   ├── auth.js           # Authentication functions
│   ├── api.js            # API calls and mock data
│   ├── charts.js         # Chart.js configurations
│   ├── dashboard.js      # Dashboard functions
│   ├── users.js          # User management
│   └── utils.js          # Utility functions
└── README.md
```

## Technologies Used

- **HTML5** - Semantic markup
- **CSS3** - Modern styling with Grid/Flexbox
- **Vanilla JavaScript** - ES6+ features
- **Chart.js** - Data visualization
- **Font Awesome** - Icons
- **Google Fonts** - Inter font family

## Getting Started

1. Clone or download this repository
2. Open `login.html` in your web browser
3. Use the demo credentials to login
4. Explore the dashboard features

## API Integration

The dashboard is designed to work with REST APIs. Currently, it uses mock data for demonstration purposes.

### To integrate with your backend:

1. Update `API_BASE_URL` in `js/api.js`
2. Replace mock API calls in `js/api.js` with real API endpoints
3. Update authentication logic in `js/auth.js`

### Example API endpoints structure:

```javascript
// Authentication
POST /api/auth/login
POST /api/auth/logout

// Users
GET /api/users
POST /api/users
PUT /api/users/:id
DELETE /api/users/:id

// Products
GET /api/products
POST /api/products
PUT /api/products/:id
DELETE /api/products/:id

// Orders
GET /api/orders
GET /api/orders/:id

// Dashboard Stats
GET /api/dashboard/stats
GET /api/dashboard/activities
```

## Features in Detail

### Dashboard Page
- 4 stat cards showing key metrics
- Revenue chart (line chart)
- User growth chart (bar chart)
- Recent activity feed

### Users Page
- Searchable user table
- Role filtering
- Pagination
- Add/Edit/Delete operations
- Export to CSV

### Products Page
- Grid view of products
- Add new products via modal
- Product categories
- Stock tracking

### Orders Page
- Order listing table
- Status badges
- Date formatting

### Analytics Page
- Sales analytics (multi-line chart)
- Category distribution (doughnut chart)
- Traffic sources (pie chart)

### Settings Page
- Profile information form
- Theme selection
- Notification toggles

## Customization

### Colors
Edit CSS variables in `css/style.css`:

```css
:root {
    --primary-color: #6366f1;
    --success-color: #10b981;
    --warning-color: #f59e0b;
    --danger-color: #ef4444;
    /* ... */
}
```

### Theme
The dashboard supports light and dark themes. Toggle between themes using the moon/sun icon in the navbar.

### Charts
Customize charts in `js/charts.js`. The dashboard uses Chart.js for all visualizations.

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## Responsive Breakpoints

- Desktop: > 1024px
- Tablet: 768px - 1024px
- Mobile: < 768px

## License

This project is open source and available for personal and commercial use.

## Support

For issues or questions, please create an issue in the repository.

## Future Enhancements

- [ ] Real-time notifications
- [ ] Advanced filtering and sorting
- [ ] Bulk operations
- [ ] File upload functionality
- [ ] Rich text editor integration
- [ ] Calendar integration
- [ ] Email templates
- [ ] Report generation
- [ ] Multi-language support
- [ ] Advanced analytics

## Credits

- Icons: [Font Awesome](https://fontawesome.com/)
- Charts: [Chart.js](https://www.chartjs.org/)
- Fonts: [Google Fonts](https://fonts.google.com/)
- Images: [Pravatar](https://pravatar.cc/) & [Picsum](https://picsum.photos/)