document.addEventListener('DOMContentLoaded', function() {

  // --- User Profile Dropdown ---
  document.addEventListener('click', function(e) {
    const profile = document.querySelector('.user-profile');
    const dropdown = document.querySelector('.user-dropdown');
    if (dropdown && profile && !profile.contains(e.target)) {
      dropdown.classList.remove('active');
    }
  });
  const userProfile = document.querySelector('.user-profile');
  if (userProfile) {
    userProfile.addEventListener('click', function() {
      const dropdown = userProfile.querySelector('.user-dropdown');
      if (dropdown) dropdown.classList.toggle('active');
    });
  }
  // --- Login Page Logic ---
  const loginForm = document.getElementById('loginForm');
  if (loginForm) {
    loginForm.addEventListener('submit', function(e) {
      e.preventDefault(); // ป้องกันการ submit ฟอร์มจริง
      // ในสถานการณ์จริง จะมีการส่งข้อมูลไปตรวจสอบกับ Server
      // ในตัวอย่างนี้ เราจะ redirect ไปที่หน้า dashboard เลย
      window.location.href = 'dashboard.html';
    });
  }

  // --- Dashboard Logic ---
  const menuToggler = document.getElementById('menu-toggler');
  const sidebar = document.querySelector('.sidebar');

  if (menuToggler && sidebar) {
    menuToggler.addEventListener('click', () => {
      sidebar.classList.toggle('active');
    });
  }

  // --- Chart.js Initialization ---
  // Chart 1: Department Scores (Bar Chart)
  const departmentChartCtx = document.getElementById('departmentChart');
  if (departmentChartCtx) {
    new Chart(departmentChartCtx, {
      type: 'bar',
      data: {
        labels: ['ฝ่ายขาย', 'การตลาด', 'ไอที', 'บุคคล', 'บัญชี'],
        datasets: [{
          label: 'คะแนนเฉลี่ย',
          data: [82, 78, 90, 85, 75],
          backgroundColor: [
            'rgba(33, 150, 243, 0.7)',
            'rgba(76, 175, 80, 0.7)',
            'rgba(255, 152, 0, 0.7)',
            'rgba(244, 67, 54, 0.7)',
            'rgba(156, 39, 176, 0.7)'
          ],
          borderColor: [
            '#2196F3',
            '#4CAF50',
            '#FF9800',
            '#F44336',
            '#9C27B0'
          ],
          borderWidth: 1,
          borderRadius: 5,
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          y: {
            beginAtZero: true,
            max: 100
          }
        },
        plugins: {
          legend: {
            display: false
          }
        }
      }
    });
  }

  // Chart 2: Performance Trend (Line Chart)
  const trendChartCtx = document.getElementById('trendChart');
  if (trendChartCtx) {
    new Chart(trendChartCtx, {
      type: 'line',
      data: {
        labels: ['ไตรมาส 1', 'ไตรมาส 2', 'ไตรมาส 3', 'ไตรมาส 4'],
        datasets: [{
          label: 'คะแนนเฉลี่ยรวม',
          data: [75, 80, 79, 88],
          fill: true,
          backgroundColor: 'rgba(33, 150, 243, 0.2)',
          borderColor: '#2196F3',
          tension: 0.4 // Makes the line smooth
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          y: {
            beginAtZero: true,
            max: 100
          }
        },
        plugins: {
          legend: {
            display: true
          }
        }
      }
    });
  }
});