# Coffee House - ร้านกาแฟออนไลน์

โปรเจกต์นี้เป็น Frontend Landing Page สำหรับร้านกาแฟออนไลน์ที่สามารถสั่งผ่านเว็บแอป ทั้งรับที่ร้านและจัดส่ง พร้อมระบบชำระเงินผ่าน QR Code

## 🤖 Prompt สำหรับสร้างโปรเจกต์

```
frontend landingpage ร้านกาแฟ online ที่สามารถสั่งผ่านเว็บแอป ที่ร้าน หรือ จัดส่ง ได้ ชำระเงินผ่าน qr ได้ ควรมีคุณสมบัติอะไรบ้าง
เทคโนโลยี html css vanila javascript

ต้องการ:
- เมนูสินค้าพร้อมรูปภาพ ตัวเลือกการปรุง
- ระบบตะกร้าสินค้า
- เลือกรับที่ร้าน/จัดส่ง
- ชำระเงินผ่าน QR Code
- รูปภาพออนไลน์
- รายการสินค้าแยกเป็น JSON
- แผนที่ร้าน
- Responsive Design
```

## คุณสมบัติหลัก

### 🏠 หน้าแรก (Hero Section)
- แสดงข้อมูลร้านและสินค้าเด่น
- Call-to-Action ที่ชัดเจน
- ดีไซน์ที่ตอบสนองทุกอุปกรณ์

### 📱 เลือกประเภทการสั่ง
- **รับที่ร้าน (Pickup)** - ไม่มีค่าจัดส่ง
- **จัดส่ง (Delivery)** - ค่าจัดส่ง 30 บาท

### 🍵 ระบบเมนู
- **หมวดหมู่สินค้า**: กาแฟ, ชา, สมูทตี้, ของหวาน
- **ตัวเลือกการปรุง**: ขนาด, ความหวาน, ความเข้มข้น
- **รูปภาพและรายละเอียดสินค้า**
- **ราคาที่ปรับตามขนาด**

### 🛒 ระบบตะกร้าสินค้า
- เพิ่ม/ลบสินค้า
- ปรับจำนวนสินค้า
- คำนวนราคารวมอัตโนมัติ
- บันทึกข้อมูลใน Local Storage

### 💳 ระบบสั่งซื้อและชำระเงิน
- กรอกข้อมูลลูกค้า (ชื่อ, เบอร์โทร)
- ที่อยู่จัดส่ง (สำหรับ Delivery)
- หมายเหตุพิเศษ
- **ชำระเงินผ่าน QR Code**
- ยืนยันการสั่งซื้อ

### 📋 ข้อมูลร้าน
- เกี่ยวกับร้าน
- ที่อยู่และข้อมูลติดต่อ
- เวลาเปิด-ปิด
- Social Media Links

## เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างเว็บไซต์
- **CSS3** - การออกแบบและ Responsive Design
- **Vanilla JavaScript** - ฟังก์ชันการทำงานและ Interactive Elements
- **Font Awesome** - ไอคอน
- **Google Fonts** - ฟอนต์ Kanit สำหรับภาษาไทย

## โครงสร้างไฟล์

```
coffee/
├── index.html          # หน้าเว็บหลัก
├── css/
│   └── style.css      # CSS สำหรับการออกแบบ
├── js/
│   ├── menu-data.js   # ตัวจัดการข้อมูลเมนู (โหลดจาก JSON)
│   ├── cart.js        # ระบบตะกร้าสินค้า
│   └── main.js        # ฟังก์ชันหลักของเว็บไซต์
├── data/
│   └── menu.json      # ข้อมูลเมนูและสินค้า (JSON)
└── images/            # โฟลเดอร์สำหรับรูปภาพ (เก็บรูปเพิ่มเติม)
```

## การปรับปรุงล่าสุด

### 🖼️ **รูปภาพจริงจาก Unsplash**
- แทนที่ emoji ด้วยรูปภาพคุณภาพสูงจาก Unsplash
- รูปภาพ responsive และโหลดเร็ว
- มี fallback image เมื่อโหลดไม่สำเร็จ
- Hero image และ About section ใช้รูปภาพจริง

### 📄 **แยกข้อมูลเป็น JSON**
- ย้ายข้อมูลเมนูจาก JavaScript ไปเป็นไฟล์ `data/menu.json`
- โหลดข้อมูลแบบ asynchronous
- ง่ายต่อการแก้ไขและจัดการข้อมูล
- รองรับการโหลดข้อมูลจาก API ในอนาคต

### 🎨 **การปรับปรุง UI**
- รูปภาพในเมนูมี hover effect
- การแสดงผลรูปภาพในตะกร้าสินค้า
- Loading animation ขณะโหลดข้อมูล
- Error handling สำหรับรูปภาพที่โหลดไม่สำเร็จ

### 🗺️ **แผนที่และข้อมูลร้าน**
- Google Maps Embed แสดงตำแหน่งร้าน
- ข้อมูลที่อยู่และการเดินทาง
- เวลาเปิด-ปิด และข้อมูลติดต่อ
- Social Media Links

## วิธีการใช้งาน

1. **เปิดเว็บไซต์**: เข้าถึงผ่าน `index.html`
2. **เลือกประเภทการสั่ง**: Pickup หรือ Delivery
3. **เลือกสินค้า**: เลือกจากเมนูและปรับแต่งตามต้องการ
4. **เพิ่มลงตะกร้า**: คลิกปุ่ม "เพิ่มลงตะกร้า"
5. **ตรวจสอบตะกร้า**: คลิกไอคอนตะกร้าเพื่อดูสินค้า
6. **สั่งซื้อ**: กรอกข้อมูลและดำเนินการชำระเงิน
7. **ชำระเงิน**: สแกน QR Code และยืนยันการชำระเงิน

## ฟีเจอร์เด่น

### 🎨 การออกแบบ
- **Responsive Design** - รองรับทุกขนาดหน้าจอ
- **Modern UI/UX** - ดีไซน์สวยงามและใช้งานง่าย
- **Color Scheme** - ใช้โทนสีน้ำตาลที่เหมาะกับธีมกาแฟ
- **Typography** - ฟอนต์ Kanit สำหรับการอ่านที่ชัดเจน

### ⚡ ประสิทธิภาพ
- **Fast Loading** - โหลดเร็วด้วย Vanilla JavaScript
- **Local Storage** - บันทึกข้อมูลตะกร้าแม้ปิดเบราว์เซอร์
- **Smooth Animations** - เอฟเค็ตการเคลื่อนไหวที่นุ่มนวล
- **Error Handling** - จัดการข้อผิดพลาดอย่างเหมาะสม

### 📱 Mobile-First
- **Touch-Friendly** - ออกแบบสำหรับการใช้งานบนมือถือ
- **Hamburger Menu** - เมนูแบบซ่อนสำหรับหน้าจอขนาดเล็ก
- **Optimized Layout** - จัดวางเนื้อหาให้เหมาะกับอุปกรณ์

## การปรับแต่ง

### เปลี่ยนข้อมูลร้าน
แก้ไขไฟล์ `index.html` ในส่วน:
- ชื่อร้าน
- ที่อยู่
- เบอร์โทรศัพท์
- เวลาเปิด-ปิด

### เพิ่มเมนูใหม่
แก้ไขไฟล์ `js/menu-data.js`:
```javascript
// เพิ่มสินค้าใหม่
{
    id: 21,
    name: "ชื่อสินค้า",
    description: "คำอธิบาย",
    price: 60,
    category: "coffee",
    image: "☕",
    options: {
        size: ["S", "M", "L"]
    }
}
```

### ปรับแต่งสี
แก้ไขไฟล์ `css/style.css`:
```css
/* เปลี่ยนสีหลัก */
:root {
    --primary-color: #8B4513;
    --secondary-color: #D2691E;
}
```

## ข้อมูลเมนูตัวอย่าง

### ☕ กาแฟ
- เอสเพรสโซ่ (45฿)
- อเมริกาโน่ (50฿)
- คาปูชิโน่ (65฿)
- ลาเต้ (70฿)
- มอคค่า (75฿)
- แมคคิอาโต้ (80฿)
- ฟราปเป้ (85฿)
- เอสเพรสโซ่โรมาโน่ (55฿)

### 🧋 ชา
- ชาไทย (40฿)
- ชาเขียว (45฿)
- ชานมไข่มุก (55฿)
- ชาอู่หลง (50฿)

### 🥤 สมูทตี้
- สมูทตี้มะม่วง (60฿)
- สมูทตี้สตรอเบอร์รี่ (65฿)
- สมูทตี้กล้วยหอม (55฿)
- สมูทตี้อโวคาโด (70฿)

### 🍰 ของหวาน
- ชีสเค้ก (85฿)
- บราวนี่ (75฿)
- ทิรามิสุ (90฿)
- ครัวซองต์ (45฿)
- มัฟฟิน (40฿)
- คุกกี้ (35฿)
- โดนัท (25฿)
- แพนเค้ก (120฿)

## การพัฒนาต่อยอด

### เชื่อมต่อ Backend
- API สำหรับจัดการคำสั่งซื้อ
- ระบบจัดการสต็อกสินค้า
- ระบบสมาชิก

### ระบบชำระเงิน
- เชื่อมต่อ Payment Gateway จริง
- รองรับบัตรเครดิต/เดบิต
- Mobile Banking

### ระบบจัดการ
- Admin Panel สำหรับจัดการเมนู
- ระบบรายงานยอดขาย
- ระบบติดตามออเดอร์

### PWA Features
- Service Worker สำหรับ Offline Support
- Push Notifications
- Add to Home Screen

## การติดตั้งและรัน

1. วางไฟล์ทั้งหมดในโฟลเดอร์เว็บเซิร์ฟเวอร์
2. เปิดเบราว์เซอร์และเข้า `http://localhost/coffee/`
3. เว็บไซต์พร้อมใช้งาน

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+
- Mobile Safari
- Chrome Mobile

---

**หมายเหตุ**: โปรเจกต์นี้เป็น Frontend Demo สำหรับการนำเสนอ สำหรับการใช้งานจริงควรพัฒนา Backend และระบบความปลอดภัยเพิ่มเติม
