# Forest Brew — เว็บตัวอย่างร้านกาแฟ

คำอธิบายสั้น ๆ

Forest Brew เป็นหน้า Landing page แบบสแตติกสำหรับร้านกาแฟสไตล์วินเทจที่รันด้วย HTML/CSS/JS (ไม่มี backend) โดยมีฟีเจอร์สำคัญดังนี้:

- เมนูดึงข้อมูลจากไฟล์ JSON (`data/menu.json`) ทำให้แก้ไขรายการได้ง่าย
- ส่วนเมนูพิเศษ (Specials) จะกรองจากค่า `special: true` ในไฟล์ JSON
- ตะกร้าสินค้า (localStorage) สำหรับการสั่งซื้อแบบจำลอง (client-side)
- แผนที่ฝังแบบ iframe (Google Maps embed) — ไม่ต้องใช้ API key
- ส่วนเพิ่มเติม: About, Testimonials, Newsletter, Contact และ Footer

โครงสร้างไฟล์หลัก

```
coffee-vintage/
├── index.html            # หน้าเว็บหลัก (HTML + JS)
├── README.md
├── data/
│   └── menu.json        # ข้อมูลเมนู (JSON)
├── assets/
│   └── images/          # รูปภาพสินค้า (webp/svg)
└── . . .
```

การรันโปรเจ็คในเครื่อง (ทดสอบง่าย ๆ)

เนื่องจากเบราว์เซอร์บางตัวบล็อก `fetch()` เมื่อเปิดไฟล์โดยตรง ให้รันเซิร์ฟเวอร์สั้น ๆ ในโฟลเดอร์โปรเจ็ค:

```bash
cd /path/to/coffee-vintage
# หากมี Python 3
python3 -m http.server 8000
```

แล้วเปิด: http://localhost:8000

แก้ไขเมนู (data/menu.json)

ไฟล์ `data/menu.json` เป็น Array ของวัตถุที่มีฟิลด์ตัวอย่าง:

```json
{
  "id": 1,
  "name": "เอสเปรสโซ ฟอเรสต์",
  "price": 45,
  "description": "เอสเปรสโซเข้มข้น จากเมล็ดคั่วสด",
  "image": "assets/images/espresso.webp",
  "special": true
}
```

คำอธิบายฟิลด์สำคัญ:
- `id` : หมายเลขประจำรายการ (ต้องไม่ซ้ำ)
- `name` : ชื่อสินค้า (สตริง)
- `price` : ราคา (ตัวเลข)
- `description` : คำอธิบายสั้น ๆ
- `image` : เส้นทางไฟล์รูปภาพ (rel path จาก root ของโปรเจ็ค)
- `special` : boolean — ถ้า `true` จะปรากฏในส่วนเมนูพิเศษ

เพิ่มรูปภาพ

วางไฟล์ภาพของสินค้าใน `assets/images/` แล้วอัปเดตค่า `image` ใน `menu.json` ให้ชี้ไปยังไฟล์นั้น (แนะนำ WebP หรือ JPEG สำหรับเว็บ)

แผนที่ (Maps)

ปัจจุบันหน้าเว็บใช้ Google Maps แบบ embed (iframe) ในส่วนแผนที่ ดังนั้นไม่ต้องใช้ API key