# LeafBox Technologies — Christmas Theme (Static Site)

## สรุปโปรเจ็ค

โปรเจ็คนี้เป็นชุดหน้าเว็บธีมคริสต์มาสสำหรับบริษัท LeafBox Technologies — บริษัทไอทีสมัยใหม่ — ออกแบบให้เรียบ หรู และเบา (minimal & elegant) โดยใช้เทคโนโลยีพื้นฐานเพียง Vanilla HTML, CSS และ JavaScript เท่านั้น (ไม่มีไลบรารีภายนอก)

## Goal
- เป้าหมาย: เปรียบเทียบผลลัพธ์จาก AI แต่ละตัวในการสร้างหน้าเว็บธีมคริสต์มาส โดยคงโครงสร้างและสไตล์ตามแนวทางที่กำหนด

## คุณสมบัติหลัก
- เลย์เอาต์สะอาด พื้นที่สีขาวเป็นหลัก พร้อมสำเนียงคริสต์มาสอ่อน ๆ (เขียวอุ่น, ขาวหิมะ, ไฮไลต์ทอง)
- ส่วนประกอบ: Hero, About, Services (การ์ดสวยงาม), Contact/Greeting, Footer
- เอฟเฟกต์คริสต์มาสอ่อน ๆ: หิมะตก (CSS / Canvas), แสงไฟจาง ๆ, ทางเลือก: นับถอยหลัง, โหมดสว่าง/มืด, hover effect
- Responsive: รองรับมือถือและเดสก์ท็อป
- โหลดเร็ว และโครงสร้าง SEO-friendly (semantic HTML)

## วิธีดู/รัน (local)
- แบบง่ายสุด: เปิด `index.html` ในโฟลเดอร์ที่ต้องการ ด้วยเบราว์เซอร์โดยตรง
- หรือรันเซิร์ฟเวอร์ไฟล์สเตติก (แนะนำ) เพื่อหลีกเลี่ยงปัญหา CORS ในสคริปต์/ฟอนต์:

  Python 3.x:

  ```bash
  python3 -m http.server 8000
  # แล้วเปิด http://localhost:8000/
  ```


## Prompt Minimal Style

```
Design a Christmas-themed website for LeafBox Technologies, a modern IT company, with a minimal and elegant style.

Guidelines:

Keep the layout clean, white, and professional, with subtle Christmas accents (soft green, snow white, gold highlights).

Use simple, geometric design elements and smooth CSS animations (e.g., gentle snowfall, glowing lights, or soft transitions).

Include these sections:

Hero section – A greeting message like “Merry Christmas from LeafBox Technologies”, with the company logo slightly decorated (small Santa hat or snow cap).

About section – A short description of the company and its mission, with a festive but minimal border or icon.

Services section – Elegant cards representing each service, using Christmas icons (gift, star, snowflake) in a subtle, modern way.

Contact / Greeting section – A friendly holiday message (“Wishing you innovation and joy this holiday season!”) and a simple contact form or button.

Footer – Clean, muted background with soft snow animation and copyright notice.

Style requirements:

Use Vanilla HTML, CSS, and JavaScript only (no external libraries).

Use responsive design suitable for both desktop and mobile.

Typography: modern sans-serif (e.g., Inter, Poppins, or Open Sans).

Include a gentle Christmas animation, like falling snow using CSS or JS canvas.

Maintain fast loading and SEO-friendly structure.

Optional Add-ons:

A countdown timer to Christmas or New Year.

Light / dark mode switch with matching holiday colors.

Small, festive cursor or hover effects.
```

## Prompt Neon Style

```
Design a Christmas-themed website for LeafBox Technologies, styled as a futuristic tech experience that blends digital innovation with the warmth of the holiday season.

Concept:
“Where technology meets the magic of Christmas.”
The design should look advanced and glowing, like a high-tech interface decorated for the holidays.

Design & Style Guidelines

Use a dark futuristic background (deep blue, midnight black, or gradient with stars or glowing lines).

Add glowing effects with neon lights in green, gold, and icy blue.

Use animated particle snow, digital light streaks, or holographic Christmas elements.

Typography: modern, thin sans-serif fonts (e.g., Orbitron, Exo, or Poppins).

Combine tech-style grids, glowing borders, and animated icons (SVG or CSS) to evoke a sense of innovation.

Use subtle motion and hover effects (fade, glow, or pulse).

Page Structure

Hero Section

A glowing digital Christmas tree made from lines or code particles.

Headline:

“Merry Christmas from LeafBox Technologies — Innovating into the Future.”

Background animation: flowing data lines or falling snow in neon colors.

About Section

Futuristic timeline showing company milestones with LED-style highlights.

Christmas accent: glowing ornaments or circuit-like snowflakes.

Services Section

Cards with holographic effects (use CSS reflections or gradient borders).

Hover animation reveals service details like “Opening a digital gift box.”

Holiday Greeting / Contact Section

Text animation: “Wishing you innovation, joy, and success this holiday season.”

Include a neon-glow contact button or AI greeting bot with festive tone.

Footer

Digital snow falling gently over glowing lines.

Countdown to Christmas / New Year with a futuristic LED clock animation.

Technical Requirements

Use Vanilla HTML, CSS, and JavaScript (no external frameworks).

Implement Canvas or CSS animations for snow or glowing effects.

Make it responsive for all devices.

Keep fast performance despite the visual richness.

Optional: Add a Dark/Light mode toggle where Light mode uses frosty white & silver tones.

Extra Features (Optional)

A 3D hologram effect for the logo or Christmas tree (using CSS perspective).

Interactive snow particles that move when the mouse hovers.

Background sound toggle with gentle digital chime or Christmas melody.

“Easter egg” — clicking certain icons reveals hidden holiday messages from the team.
```