# Dashboard Project

โปรเจ็คนี้เป็นระบบ Dashboard สำหรับแสดงข้อมูลสถิติต่าง ๆ จากฐานข้อมูล MySQL และไฟล์ CSV โดยสามารถแสดงผลในรูปแบบการ์ด ตาราง และกราฟ พร้อมรองรับการรีเฟรชข้อมูลอัตโนมัติและการจัดรูปแบบตามเงื่อนไข

## โครงสร้างโปรเจ็ค

- `index.html` — หน้าเว็บหลักของ Dashboard
- `css/style.css` — ไฟล์สไตล์สำหรับตกแต่งหน้าตา Dashboard
- `js/dashboard.js` — สคริปต์ฝั่ง client สำหรับโหลดและแสดงข้อมูล
- `api/data_source.php` — API สำหรับดึงข้อมูลจากฐานข้อมูลหรือไฟล์ CSV
- `setup_database.sql` — สคริปต์สำหรับสร้างฐานข้อมูลและตารางตัวอย่าง
- `data/` — โฟลเดอร์เก็บไฟล์ข้อมูล CSV
- `configs/dashboard.json` — คอนฟิกหน้าหลักของ Dashboard
- `configs/widgets/` — คอนฟิกของแต่ละ widget (เช่น การ์ด, ตาราง, กราฟ)

## วิธีติดตั้งและใช้งาน

1. **เตรียมฐานข้อมูล**
   - สร้างฐานข้อมูล MySQL และนำไฟล์ `setup_database.sql` ไป import
   - แก้ไขข้อมูลการเชื่อมต่อในไฟล์คอนฟิก widgets ให้ตรงกับฐานข้อมูลของคุณ

2. **ตั้งค่าเว็บเซิร์ฟเวอร์**
   - วางโฟลเดอร์โปรเจ็คนี้ไว้ในโฟลเดอร์ของเว็บเซิร์ฟเวอร์ (เช่น XAMPP, Apache, Nginx)
   - ตรวจสอบให้แน่ใจว่า PHP สามารถเชื่อมต่อฐานข้อมูลได้

3. **เปิดใช้งาน Dashboard**
   - เข้าผ่านเบราว์เซอร์ที่ `http://localhost/your_project_path/index.html`

## ตัวอย่าง Widget

- **1_user_count_card.json**: แสดงจำนวนผู้ใช้ทั้งหมด
- **2_product_price_chart.json**: กราฟราคาสินค้า
- **3_recent_orders_table.json**: ตารางรายการสั่งซื้อล่าสุด
- **4_api_users_table.json**: ตารางข้อมูลผู้ใช้จาก API

## การตั้งค่าฐานข้อมูลในไฟล์คอนฟิก

ในแต่ละ widget ที่เชื่อมต่อฐานข้อมูล (เช่น `1_user_count_card.json`, `3_recent_orders_table.json`)
จะมีโครงสร้างการตั้งค่าดังนี้:

```json
"connection": {
  "host": "localhost",
  "dbname": "my_dashboard_db",
  "user": "root",
  "password": ""
}
```

- **host**: ชื่อโฮสต์ของ MySQL (เช่น `localhost`)
- **dbname**: ชื่อฐานข้อมูล
- **user**: ชื่อผู้ใช้ MySQL
- **password**: รหัสผ่าน (ถ้าไม่ได้ตั้งรหัสผ่าน ให้เว้นว่าง "")

> **หมายเหตุ**: หากใช้งานจริงควรตั้งรหัสผ่านให้ user และแก้ไขในไฟล์คอนฟิกให้ตรงกับฐานข้อมูลของคุณ

---

**ผู้พัฒนา:**
- Goragod Wiriya

**AI:**
- Google AI Studio

วันที่อัปเดตล่าสุด: 10 กรกฎาคม 2568
