CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `users` (`id`, `username`, `email`) VALUES
(1, 'somsak', 'somsak@example.com'),
(2, 'somchai', 'somchai@example.com'),
(3, 'somsri', 'somsri@example.com');

CREATE TABLE `orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_username` varchar(50) NOT NULL,
  `order_date` date NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('Processing','Shipped','Completed','Cancelled') NOT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `orders` (`order_id`, `customer_username`, `order_date`, `total_amount`, `status`) VALUES
(101, 'somsak', '2023-10-25', 1500.00, 'Completed'),
(102, 'somchai', '2023-10-26', 750.50, 'Shipped'),
(103, 'somsri', '2023-10-26', 3200.00, 'Processing'),
(104, 'somsak', '2023-10-27', 250.00, 'Completed'),
(105, 'somsri', '2023-10-28', 120.00, 'Cancelled');