export class AppContainer {
    constructor() {
        // สร้าง Dependencies
        this.settingsManager = new SettingsManager();
        this.authSystem = new AuthSystem();
        this.productManager = new ProductManager();
        this.customerStorage = new CustomerStorage();
        this.notificationSystem = new NotificationSystem(
            this.settingsManager.getSetting('notifications')
        );
        
        // สร้าง Order Manager พร้อม Dependencies
        this.orderManager = new OrderManager({
            productManager: this.productManager,
            notificationSystem: this.notificationSystem,
            customerStorage: this.customerStorage,
            settingsManager: this.settingsManager
        });
    }

    async initialize() {
        // เริ่มต้นระบบทั้งหมด
        await Promise.all([
            this.initializeUI(),
            this.setupEventListeners(),
            this.checkAuthentication()
        ]);
    }

    async initializeUI() {
        // โหลดการตั้งค่าและอัพเดท UI
        const settings = this.settingsManager.settings;
        document.title = settings.site.name;
        this.updateUIWithSettings(settings);
    }

    setupEventListeners() {
        // ตั้งค่า Event Listeners ทั้งหมด
        this.setupCartListeners();
        this.setupAuthListeners();
        this.setupProductListeners();
    }

    async checkAuthentication() {
        if (this.authSystem.isAuthenticated()) {
            this.showAdminFeatures();
        }
    }

    updateUIWithSettings(settings) {
        // อัพเดท UI ตามการตั้งค่า
        document.querySelector('#siteName').textContent = settings.site.name;
        document.querySelector('#siteDescription').textContent = settings.site.description;
        // อัพเดทส่วนอื่นๆ ตามการตั้งค่า
    }

    // สามารถเพิ่มเมธอดอื่นๆ ตามต้องการ
}
