const AuthManager = {
    init() {
        this.setupLoginForm();
    },

    setupLoginForm() {
        const loginForm = document.getElementById('loginForm');
        if (loginForm) {
            loginForm.addEventListener('submit', (e) => this.handleLogin(e));
        }
    },

    async handleLogin(e) {
        e.preventDefault();
        
        const username = document.getElementById('username').value;
        const password = document.getElementById('password').value;

        try {
            Utils.showLoading();
            
            // จำลองการเช็คล็อกอิน (ในที่นี้ใช้ค่าทดสอบ)
            if (username === 'admin' && password === 'admin') {
                // Login success
                const userData = {
                    username: username,
                    role: 'admin',
                    timestamp: Date.now()
                };

                Storage.save('userData', userData);
                this.updateUIForAuth(userData);
                ModalManager.hideModal('loginModal');
                NotificationManager.showSuccess('เข้าสู่ระบบสำเร็จ');
            } else {
                throw new Error('ชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง');
            }
        } catch (error) {
            console.error('Login error:', error);
            NotificationManager.showError(error.message);
        } finally {
            Utils.hideLoading();
        }
    },

    updateUIForAuth(userData) {
        const loginBtn = document.getElementById('loginBtn');
        if (loginBtn) {
            loginBtn.innerHTML = `
                <i class="fas fa-user"></i>
                ${userData.username}
            `;
        }

        // แสดงปุ่มออกจากระบบ
        const logoutBtn = document.createElement('button');
        logoutBtn.className = 'button-modern';
        logoutBtn.innerHTML = '<i class="fas fa-sign-out-alt"></i> ออกจากระบบ';
        logoutBtn.onclick = () => this.handleLogout();
        
        loginBtn.parentNode.appendChild(logoutBtn);
    },

    handleLogout() {
        Storage.remove('userData');
        window.location.reload();
    }
};
