<?php
/**
 * Simple Authentication System for Photo Gallery
 * Provides basic login/logout functionality with session management
 */
require_once 'classes/SimpleAuth.php';

// Handle authentication API requests
if (isset($_GET['action'])) {
    header('Content-Type: application/json');
    $auth = new SimpleAuth();

    switch ($_GET['action']) {
        case 'login':
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $input = json_decode(file_get_contents('php://input'), true);
                $result = $auth->login($input['username'] ?? '', $input['password'] ?? '');
                echo json_encode($result);
            } else {
                echo json_encode(['success' => false, 'error' => 'Method not allowed']);
            }
            break;

        case 'logout':
            $result = $auth->logout();
            echo json_encode($result);
            break;

        case 'check':
            echo json_encode($auth->getCurrentUser());
            break;

        default:
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
    }
    exit;
}
