# Modern Photo Gallery

แกลอรี่รูปภาพแบบโมเดิร์นที่สวยงาม พร้อมฟีเจอร์ครบครัน

## ฟีเจอร์หลัก

### 🎨 การออกแบบ
- **Modern UI Design** - ใช้ Gradient สีน้ำเงินเข้มที่สวยงาม
- **Glass Morphism Effect** - เอฟเฟกต์กระจกด้านขุ่นที่ทันสมัย
- **Google Fonts (Inter)** - ฟอนต์ที่อ่านง่ายและสวยงาม
- **Responsive Design** - รองรับทุกขนาดหน้าจอ

### 📸 การจัดการรูปภาพ
- **Album View** - แสดงรูปภาพเป็นอัลบัม
- **Grid Layout** - จัดเรียงรูปภาพแบบกริดที่สวยงาม
- **Infinite Scroll** - โหลดรูปภาพแบบค่อยเป็นค่อยไป
- **Image Caching** - แคชรูปภาพเพื่อการโหลดที่เร็วขึ้น

### 🎬 Slideshow
- **Full Screen Slideshow** - ดูรูปภาพแบบเต็มจอ
- **Keyboard Navigation** - ใช้ลูกศรซ้าย-ขวาเพื่อเปลี่ยนรูป
- **Mouse Navigation** - คลิกปุ่มเพื่อเปลี่ยนรูป
- **Image Counter** - แสดงหมายเลขรูปภาพปัจจุบัน

### ⚡ ประสิทธิภาพ
- **Lazy Loading** - โหลดรูปภาพเมื่อจำเป็น
- **Pagination** - แบ่งรูปภาพเป็นหน้า ๆ
- **Background Images** - ใช้ CSS background สำหรับการแสดงผลที่เร็ว
- **API Caching** - แคชข้อมูลเพื่อลดการเรียก API

## โครงสร้างไฟล์

```
album/
├── index.html          # หน้าหลัก
├── styles.css          # สไตล์ CSS
├── script.js           # JavaScript หลัก
├── api.php             # PHP API
├── install.php         # สคริปต์ติดตั้งแบบ CLI
├── auth.php            # ระบบ Authentication
├── check-upload-limits.php  # ตรวจสอบ Upload Limits
├── classes/            # PHP Classes
│   ├── DataManager.php     # จัดการข้อมูล
│   ├── ErrorHandler.php    # จัดการข้อผิดพลาด
│   ├── FileUploadHandler.php  # จัดการการอัปโหลด
│   ├── ImageProcessor.php  # ประมวลผลรูปภาพ
│   ├── InputValidator.php  # ตรวจสอบข้อมูลที่รับเข้ามา
│   ├── RSSGenerator.php    # สร้าง RSS Feed
│   └── SimpleAuth.php      # ระบบยืนยันตัวตน
├── data/               # ข้อมูลแอปพลิเคชัน (สร้างโดยอัตโนมัติ)
│   ├── config.json         # การตั้งค่า
│   ├── albums.json         # ข้อมูลอัลบัม
│   ├── tags.json          # ข้อมูลแท็ก
│   ├── counters.json      # ตัวนับ
│   └── cache/             # แคชข้อมูล
├── logs/               # ไฟล์ log (สร้างโดยอัตโนมัติ)
├── albums/             # โฟลเดอร์รูปภาพ
│   ├── 1/
│   ├── 2/
│   └── ...
└── README.md           # ไฟล์นี้
```

## การติดตั้งและใช้งาน

### ความต้องการระบบ
- Web Server (Apache/Nginx)
- PHP 7.4+ พร้อม Extensions:
  - GD Extension (สำหรับการประมวลผลรูปภาพ)
  - JSON Extension (สำหรับการจัดเก็บข้อมูล)
  - File Upload Support
- Browser ที่รองรับ ES6+

### วิธีการติดตั้ง

#### 1. การติดตั้งแบบ CLI (แนะนำ)
```bash
# เข้าไปยังโฟลเดอร์ของโปรเจค
cd /path/to/album

# รันสคริปต์ติดตั้ง
php install.php

# หรือใช้ตัวเลือกเพิ่มเติม:
php install.php --force       # บังคับติดตั้งทับข้อมูลเดิม
php install.php --config-only # สร้างเฉพาะไฟล์ config
```

สคริปต์ติดตั้งจะทำการ:
- ✅ ตรวจสอบความต้องการระบบ
- 📁 สร้างโครงสร้างโฟลเดอร์ (`data/`, `logs/`, `albums/`)
- 📄 สร้างไฟล์ข้อมูลเริ่มต้น (JSON files)
- 🔍 สแกนและจัดระเบียบรูปภาพที่มีอยู่
- 🔐 ตั้งค่าสิทธิ์ไฟล์ให้เหมาะสม

#### 2. การติดตั้งแบบ Manual
1. วางไฟล์ทั้งหมดใน Web Server
2. สร้างโฟลเดอร์ `data/`, `data/cache/`, `logs/`
3. ตั้งค่าสิทธิ์โฟลเดอร์ให้เขียนได้ (755)
4. เปิดเว็บเบราว์เซอร์และไปที่ `http://localhost/album/`

### โครงสร้างอัลบัม
รูปภาพควรจัดเก็บในโฟลเดอร์ `albums/` ตามรูปแบบ:
```
albums/
├── 1/
│   ├── 0.webp
│   ├── 1.webp
│   └── ...
├── 2/
│   ├── 0.webp
│   ├── 1.webp
│   └── ...
```

**รูปแบบไฟล์ที่รองรับ:** `.jpg`, `.jpeg`, `.png`, `.gif`, `.webp`, `.bmp`, `.tiff`

**หมายเหตุ:** หากมีรูปภาพอยู่แล้วในโฟลเดอร์ `albums/` สคริปต์ติดตั้งจะสแกนและสร้างข้อมูลอัลบัมให้อัตโนมัติ

## การใช้งาน

### หน้าแรก
- แสดงรายการอัลบัมทั้งหมด
- คลิกที่อัลบัมเพื่อเข้าดูรูปภาพ

### หน้าอัลบัม
- แสดงรูปภาพในอัลบัมแบบกริด
- เลื่อนลงเพื่อโหลดรูปภาพเพิ่มเติม
- คลิกที่รูปภาพเพื่อเปิด Slideshow

## การปรับแต่ง

### เปลี่ยนสีธีม
แก้ไขไฟล์ `styles.css` ในส่วน:
```css
background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
```

### เปลี่ยนจำนวนรูปต่อหน้า
แก้ไขไฟล์ `script.js`:
```javascript
this.photosPerPage = 20; // เปลี่ยนเป็นจำนวนที่ต้องการ
```

## เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างหน้าเว็บ
- **CSS3** - การจัดรูปแบบและเอฟเฟกต์
- **Vanilla JavaScript** - ฟังก์ชันการทำงาน
- **PHP** - API สำหรับดึงข้อมูล
- **Google Fonts** - ฟอนต์ Inter

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+

## ข้อดี

✅ ไม่ใช้ Framework ภายนอก
✅ โหลดเร็ว เพราะใช้ Background Images
✅ รองรับ Mobile และ Desktop
✅ มี Infinite Scroll
✅ มีระบบ Caching
✅ UI/UX ที่สวยงามและทันสมัย

## การแก้ปัญหา

### รูปภาพไม่แสดง
- ตรวจสอบว่าชื่อโฟลเดอร์เก็บรูปภาพเป็นตัวเลข (1, 2, 3, ...)
- ตรวจสอบ path ของโฟลเดอร์ `albums/`
- ตรวจสอบสิทธิ์อ่านไฟล์และโฟลเดอร์
- ตรวจสอบรูปแบบไฟล์ (ต้องเป็น `.jpg`, `.jpeg`, `.png`, `.gif`, `.webp`, `.bmp`, `.tiff`)

### API ไม่ทำงาน
- ตรวจสอบว่า PHP ทำงานได้และมี Extension ที่จำเป็น
- ตรวจสอบ error log ของ web server
- ตรวจสอบ Console ใน Developer Tools
- ตรวจสอบไฟล์ `logs/api_error.log`

### ปัญหาการติดตั้ง
- รันคำสั่ง `php install.php --force` เพื่อติดตั้งใหม่
- ตรวจสอบสิทธิ์การเขียนไฟล์ในโฟลเดอร์
- ตรวจสอบ PHP version และ Extensions ที่จำเป็น
- ดูรายละเอียดข้อผิดพลาดจากการรันสคริปต์ติดตั้ง


## ระบบยืนยันตัวตน (Authentication)

ระบบนี้ใช้คลาส `SimpleAuth` สำหรับจัดการการเข้าสู่ระบบและรหัสผ่าน โดยรหัสผ่านจะถูกเข้ารหัส (hash) ด้วยฟังก์ชันมาตรฐานของ PHP เพื่อความปลอดภัย ค่าเริ่มต้นคือ username `admin` password `admin123`

### ตัวอย่างการเข้ารหัสรหัสผ่านใหม่

```php
require_once 'classes/SimpleAuth.php';
$auth = new SimpleAuth();
$plainPassword = 'mypassword';
$hashed = $auth->hashPassword($plainPassword);
echo $hashed; // นำค่า hash ที่ได้ไปแทนที่ใน adminCredentials
```

### การเปลี่ยนรหัสผ่าน (ในโค้ด)

```php
$result = $auth->changePassword('admin', 'รหัสผ่านเดิม', 'รหัสผ่านใหม่');
if ($result['success']) {
    // เปลี่ยนรหัสผ่านสำเร็จ
}
```

> **หมายเหตุ:**
> - ค่าใน `$adminCredentials` จะต้องเป็น hash เท่านั้น ไม่ควรเก็บรหัสผ่านจริง
> - ใช้ `password_verify()` ในการตรวจสอบรหัสผ่านอัตโนมัติ

---

**สร้างด้วย ❤️ สำหรับการแสดงรูปภาพที่สวยงามและทันสมัย**