// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
  const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
  const mainNav = document.getElementById('main-nav');

  if (mobileMenuToggle && mainNav) {
    mobileMenuToggle.addEventListener('click', function() {
      mainNav.classList.toggle('active');
    });
  }

  // Product tabs
  const tabButtons = document.querySelectorAll('.tab-btn');
  const tabContents = document.querySelectorAll('.tab-content');

  if (tabButtons.length > 0 && tabContents.length > 0) {
    tabButtons.forEach(button => {
      button.addEventListener('click', function() {
        const tabId = this.getAttribute('data-tab');

        // Remove active class from all buttons and contents
        tabButtons.forEach(btn => btn.classList.remove('active'));
        tabContents.forEach(content => content.classList.remove('active'));

        // Add active class to clicked button and corresponding content
        this.classList.add('active');
        const targetContent = document.getElementById(tabId);
        if (targetContent) {
          targetContent.classList.add('active');
        }
      });
    });
  }

  // Product image gallery
  const mainProductImage = document.getElementById('main-product-image');
  const thumbnails = document.querySelectorAll('.thumbnail');

  if (mainProductImage && thumbnails.length > 0) {
    thumbnails.forEach(thumbnail => {
      thumbnail.addEventListener('click', function() {
        // Remove active class from all thumbnails
        thumbnails.forEach(t => t.classList.remove('active'));

        // Add active class to clicked thumbnail
        this.classList.add('active');

        // Change main image source
        const thumbnailSrc = this.getAttribute('src');
        if (thumbnailSrc) {
          mainProductImage.setAttribute('src', thumbnailSrc);
        }
      });
    });
  }

  // Lazy loading for images
  if ('IntersectionObserver' in window) {
    const lazyImages = document.querySelectorAll('img[loading="lazy"]');

    const imageObserver = new IntersectionObserver((entries, observer) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          const img = entry.target;
          img.src = img.dataset.src || img.src;
          img.classList.remove('lazy');
          imageObserver.unobserve(img);
        }
      });
    });

    lazyImages.forEach(img => {
      imageObserver.observe(img);
    });
  }

  // Form validation
  const contactForm = document.querySelector('.contact-form form');

  if (contactForm) {
    contactForm.addEventListener('submit', function(e) {
      e.preventDefault();

      // Basic form validation
      const name = document.getElementById('name').value.trim();
      const email = document.getElementById('email').value.trim();
      const subject = document.getElementById('subject').value;
      const message = document.getElementById('message').value.trim();

      let isValid = true;
      let errorMessage = '';

      if (name === '') {
        isValid = false;
        errorMessage += 'Please enter your name.\n';
      }

      if (email === '') {
        isValid = false;
        errorMessage += 'Please enter your email.\n';
      } else if (!isValidEmail(email)) {
        isValid = false;
        errorMessage += 'Please enter a valid email address.\n';
      }

      if (subject === '') {
        isValid = false;
        errorMessage += 'Please select a subject.\n';
      }

      if (message === '') {
        isValid = false;
        errorMessage += 'Please enter your message.\n';
      }

      if (isValid) {
        // In a real application, you would submit the form to a server
        // For this demo, we'll just show a success message
        const formContainer = document.querySelector('.contact-form');
        formContainer.innerHTML = `
                  <div class="success-message">
                      <h3>Thank you for your message!</h3>
                      <p>We'll get back to you as soon as possible.</p>
                      <button class="btn btn-primary" onclick="location.reload()">Send Another Message</button>
                  </div>
              `;
      } else {
        alert(errorMessage);
      }
    });
  }

  // Newsletter form
  const newsletterForm = document.querySelector('.newsletter form');

  if (newsletterForm) {
    newsletterForm.addEventListener('submit', function(e) {
      e.preventDefault();

      const email = this.querySelector('input[type="email"]').value.trim();

      if (email === '') {
        alert('Please enter your email address.');
        return;
      }

      if (!isValidEmail(email)) {
        alert('Please enter a valid email address.');
        return;
      }

      // In a real application, you would submit the form to a server
      // For this demo, we'll just show a success message
      const formContainer = document.querySelector('.newsletter');
      formContainer.innerHTML = `
              <div class="success-message">
                  <h3>Thank you for subscribing!</h3>
                  <p>You'll receive our latest deals and offers in your inbox.</p>
              </div>
          `;
    });
  }

  // Sort functionality
  const sortSelect = document.getElementById('sort');

  if (sortSelect) {
    sortSelect.addEventListener('change', function() {
      const sortValue = this.value;
      const currentUrl = new URL(window.location);
      currentUrl.searchParams.set('sort', sortValue);
      window.location.href = currentUrl.toString();
    });
  }

  // Filter functionality
  const filterLinks = document.querySelectorAll('.filter-group a');

  if (filterLinks.length > 0) {
    filterLinks.forEach(link => {
      link.addEventListener('click', function(e) {
        e.preventDefault();

        const href = this.getAttribute('href');
        if (href && href !== '#') {
          window.location.href = href;
        }
      });
    });
  }

  // Retailer buttons
  const retailerButtons = document.querySelectorAll('.retailer-btn');

  if (retailerButtons.length > 0) {
    retailerButtons.forEach(button => {
      button.addEventListener('click', function(e) {
        e.preventDefault();

        // In a real application, this would redirect to the retailer's site
        // For this demo, we'll just show an alert
        const retailer = this.getAttribute('data-retailer');
        const price = this.getAttribute('data-price');

        alert(`You would be redirected to ${retailer} to purchase this product for ${price}.`);
      });
    });
  }

  // Load more reviews
  const loadMoreButton = document.querySelector('.load-more button');

  if (loadMoreButton) {
    loadMoreButton.addEventListener('click', function() {
      // In a real application, this would load more reviews from a server
      // For this demo, we'll just show an alert
      alert('In a real application, more reviews would be loaded here.');
    });
  }
});

// Helper function to validate email
function isValidEmail(email) {
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return emailRegex.test(email);
}

// Function to change main product image
function changeMainImage(src) {
  const mainProductImage = document.getElementById('main-product-image');
  if (mainProductImage && src) {
    mainProductImage.setAttribute('src', src);
  }
}