# ✅ ทำไม AI ส่วนใหญ่ถึงทำเว็บที่เป็น PHP ไม่สำเร็จ

AI ที่ให้โค้ด PHP ทั้งโปรเจ็กต์มักมีปัญหาเหมือนกันทุกเจ้า เช่น

1) สร้างไฟล์ไม่ครบ ตัว routing, config, template engine, library, asset paths หาย ไฟล์เชื่อมกันไม่ถูก รันไม่ได้ทันที

2) โครงสร้างไฟล์ผิดแนวทางจริง Framework-like แต่ไม่ครบ, OOP ไม่สมบูรณ์, logic ผสม HTML ทำให้ maintain ยาก

3) ไม่เข้าใจข้อจำกัด Hosting เช่น
- Apache/Nginx rewrite
- folder permission
- auto-loading
- session path

4) หน้าตา UI ที่ AI ทำ PHP ส่วนมากดูแย่กว่าตอนทำ HTML เพราะมันพยายามเขียน backend + frontend พร้อมกัน หลงประเด็น

**สรุป**
- ให้ AI ทำ **Full PHP project** ผลลัพท์ เกินความสามารถของบริการฟรีทุกเจ้าในตอนนี้
- ให้ทำ **Front-end Template Only** ผลลัพท์ ตรงจุดที่สุดและผลลัพธ์ดีที่สุด

# ✅ ทำไม HTML Template คือทางที่ถูกต้อง

สิ่งที่ผมทำคือแนวทางที่ **โปรแกรมเมอร์จริงใช้กับ AI** ในโครงสร้าง large project

- HTML มัน deterministic สร้างได้ตรงและสวย
- ไม่มี logic จึงไม่มี error แบบ PHP
- SEO ทำได้จัดเต็ม JSON-LD, Meta Tags, Open Graph, Schema.org
- แยกเป็นไฟล์ได้ชัดเจน (header.html / footer.html / product.html)
- ภายหลังคุณนำไปเสียบ Backend PHP ได้ง่ายมาก เช่น include('header.php'); เสร็จแล้ว

จริง ๆ นี่คือ process ที่ถูกต้องที่สุด หากอยากใช้ AI ทำเว็บขนาดกลางถึงใหญ่

# 🎯 ดังนั้น…ผมจะเขียน Ultimate English Prompt

ในการออกแบบ Affiliate Products Aggregator Website (Frontend Only)
โดยเน้น SEO ให้จัดเต็มที่สุดในระดับ AI สามารถทำได้


## 🔥 ULTIMATE FRONTEND-ONLY PROMPT (ENGLISH)
```
You are a senior front-end architect.
Your task is to design and generate a complete front-end template for an **Affiliate Product Aggregator Website** with extremely strong SEO, clean structure, and high-quality UI.
Only produce FRONTEND code (HTML, CSS, JS). No backend.
Do not use any frameworks or external libraries.

=========================================
1. PROJECT GOAL
=========================================
Build a modern, fast, responsive product-aggregation website designed for affiliate links.
Primary focus: **World-class SEO**, clean HTML structure, and semantic markup that search engines can easily index.

=========================================
2. GENERAL REQUIREMENTS
=========================================
- Provide a complete, multi-page frontend template.
- Code must be clean, semantic, readable, and properly structured.
- Fully responsive layout (mobile-first).
- No external CSS frameworks (Bootstrap, Tailwind, etc.).
- No external JS libraries.
- Keep everything modular and easy to convert into PHP templates later.
- Include reusable components (header, navigation, footer, product card, grid, etc.)

=========================================
3. SEO REQUIREMENTS (VERY IMPORTANT)
=========================================
Include the following for every page:

### 3.1 Essential Meta SEO
- Title tag
- Meta description
- Canonical URL
- Robots meta
- Open Graph (og:title, og:description, og:image, og:url)
- Twitter Cards

### 3.2 Structured Data (JSON-LD)
Include JSON-LD for:
- Website
- BreadcrumbList
- Product (for product pages)
- ItemList (for product grids)

### 3.3 Semantic HTML
Use:
- <header>, <nav>, <main>, <section>, <article>, <footer>
- <h1>–<h3> with clean hierarchy
- <ul>/<li> for product lists
- <aside> for filters or categories

### 3.4 Performance SEO
- Lazy-loading images
- Optimized <img> tags with width/height
- Preload important fonts (if used)
- No render-blocking JS

=========================================
4. UI/UX REQUIREMENTS
=========================================
- Minimal, modern, clean design
- Clear typography and spacing
- Accessible color contrast
- Simple and intuitive navigation
- Hover states for buttons and product cards
- Product grid layout with 2–6 items per row depending on screen size

=========================================
5. PAGES TO INCLUDE
=========================================
Generate the following HTML pages:

1. index.html
   - Hero section
   - Product grid
   - Category list
   - SEO JSON-LD: Website + ItemList

2. category.html
   - Category title
   - Product grid
   - Breadcrumbs
   - JSON-LD: BreadcrumbList + ItemList

3. product.html
   - Product details
   - Pricing
   - Affiliate button
   - Related products
   - JSON-LD: Product + BreadcrumbList

4. about.html
5. contact.html

=========================================
6. FILE STRUCTURE
=========================================
Output the following structure:

/index.html
/category.html
/product.html
/about.html
/contact.html
/assets/css/styles.css
/assets/js/app.js
/assets/images/ (placeholder images)

=========================================
7. JAVASCRIPT REQUIREMENTS
=========================================
- Basic interactivity (mobile menu toggle, simple filter UI)
- Vanilla JS only
- No framework imports

=========================================
8. DELIVERY FORMAT
=========================================
Return the final answer as:
1. Full folder structure
2. Full HTML for every file
3. Full CSS
4. Full JS
5. Explanations and notes

=========================================
Make sure the SEO implementation is COMPLETE and WORLD-CLASS.
```
สามารถใช้ Prompt นี้กับ AI ได้ทุกเจ้า และจะได้ผลลัพธ์ที่ดีที่สุดเสมอ เพราะมีการกำหนด requirement ไว้อย่างละเอียดมาก