# AdminHub

A modern, responsive admin dashboard built with HTML, CSS, and JavaScript, featuring a clean UI with dark mode support and interactive charts.

## Author

Goragod Wiriya

## AI

deepseek

## Description

AdminHub is a comprehensive admin dashboard that provides an intuitive interface for managing users, products, orders, and analytics. It includes a dashboard overview with key metrics, user management with search and filtering capabilities, order tracking, analytics with various chart visualizations, and customizable settings including dark mode toggle.

## Features

- **Dashboard**: Overview with key metrics, sales charts, and recent activity
- **User Management**: Add, edit, delete users with search and role-based filtering
- **Product Management**: Manage product inventory (placeholder sections)
- **Order Management**: Track orders with status updates and export functionality
- **Analytics**: Interactive charts for traffic, revenue, top products, and customer acquisition
- **Settings**: General settings, notifications, and security options with dark mode toggle
- **Responsive Design**: Works seamlessly on desktop and mobile devices
- **Modern UI**: Clean design with animations and smooth transitions

## Technologies Used

- **HTML5**: Semantic markup
- **Tailwind CSS**: Utility-first CSS framework
- **JavaScript**: Vanilla JS for interactivity
- **Chart.js**: Data visualization library
- **Feather Icons**: Lightweight icon library
- **AOS (Animate On Scroll)**: Animation library for scroll effects
- **Vanta.js**: Background effects (globe animation)

## Installation

1. Clone this repository:
   ```bash
   git clone <repository-url>
   cd admin-hub
   ```

2. Open `index.html` in your web browser, or serve with a local web server for better experience:
   ```bash
   python -m http.server 8000
   ```
   Then visit `http://localhost:8000`

## Usage

- Navigate through different sections using the sidebar menu
- Toggle between light and dark modes in Settings
- Use search and filter options in management sections
- View interactive charts in the Analytics section

## Browser Support

- Chrome (recommended)
- Firefox
- Safari
- Edge

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- Icons provided by [Feather Icons](https://feathericons.com/)
- Charts powered by [Chart.js](https://www.chartjs.org/)
- Animations by [AOS](https://michalsnik.github.io/aos/)
- Background effects by [Vanta.js](https://www.vantajs.com/)